/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.http.netty4;

import conductor.com.carrotsearch.hppc.IntHashSet;
import conductor.io.netty.bootstrap.ServerBootstrap;
import conductor.io.netty.channel.AdaptiveRecvByteBufAllocator;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelFuture;
import conductor.io.netty.channel.ChannelHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.channel.ChannelInitializer;
import conductor.io.netty.channel.ChannelOption;
import conductor.io.netty.channel.FixedRecvByteBufAllocator;
import conductor.io.netty.channel.RecvByteBufAllocator;
import conductor.io.netty.channel.nio.NioEventLoopGroup;
import conductor.io.netty.channel.socket.nio.NioServerSocketChannel;
import conductor.io.netty.handler.codec.ByteToMessageDecoder;
import conductor.io.netty.handler.codec.http.HttpContentCompressor;
import conductor.io.netty.handler.codec.http.HttpContentDecompressor;
import conductor.io.netty.handler.codec.http.HttpMethod;
import conductor.io.netty.handler.codec.http.HttpObjectAggregator;
import conductor.io.netty.handler.codec.http.HttpRequestDecoder;
import conductor.io.netty.handler.codec.http.HttpResponseEncoder;
import conductor.io.netty.handler.timeout.ReadTimeoutException;
import conductor.io.netty.handler.timeout.ReadTimeoutHandler;
import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.component.AbstractLifecycleComponent;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.network.NetworkAddress;
import conductor.org.elasticsearch.common.network.NetworkService;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.settings.SettingsException;
import conductor.org.elasticsearch.common.transport.BoundTransportAddress;
import conductor.org.elasticsearch.common.transport.NetworkExceptionHelper;
import conductor.org.elasticsearch.common.transport.PortsRange;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.common.unit.ByteSizeUnit;
import conductor.org.elasticsearch.common.unit.ByteSizeValue;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.concurrent.EsExecutors;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.http.BindHttpException;
import conductor.org.elasticsearch.http.HttpInfo;
import conductor.org.elasticsearch.http.HttpServerTransport;
import conductor.org.elasticsearch.http.HttpStats;
import conductor.org.elasticsearch.http.HttpTransportSettings;
import conductor.org.elasticsearch.http.netty4.Netty4HttpRequestHandler;
import conductor.org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import conductor.org.elasticsearch.http.netty4.cors.Netty4CorsConfigBuilder;
import conductor.org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import conductor.org.elasticsearch.http.netty4.pipelining.HttpPipeliningHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.RestUtils;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.BindTransportException;
import conductor.org.elasticsearch.transport.netty4.Netty4OpenChannelsHandler;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Netty4HttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4HttpServerTransport.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    private static final ByteSizeValue MTU;
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT;
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE;
    @Deprecated
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN;
    @Deprecated
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX;
    private final Settings settings;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ByteSizeValue maxContentLength;
    protected final ByteSizeValue maxInitialLineLength;
    protected final ByteSizeValue maxHeaderSize;
    protected final ByteSizeValue maxChunkSize;
    protected final int workerCount;
    protected final boolean pipelining;
    protected final int pipeliningMaxEvents;
    protected final boolean compression;
    protected final int compressionLevel;
    protected final boolean resetCookies;
    protected final PortsRange port;
    protected final String[] bindHosts;
    protected final String[] publishHosts;
    protected final boolean detailedErrorsEnabled;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final ByteSizeValue tcpSendBufferSize;
    protected final ByteSizeValue tcpReceiveBufferSize;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    protected final int maxCompositeBufferComponents;
    private final HttpServerTransport.Dispatcher dispatcher;
    protected volatile ServerBootstrap serverBootstrap;
    protected volatile BoundTransportAddress boundAddress;
    protected final List<Channel> serverChannels = new ArrayList<Channel>();
    Netty4OpenChannelsHandler serverOpenChannels;
    private final Netty4CorsConfig corsConfig;

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings);
        this.settings = settings;
        Netty4Utils.setAvailableProcessors(EsExecutors.PROCESSORS_SETTING.get(settings));
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.dispatcher = dispatcher;
        ByteSizeValue maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.maxChunkSize = HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.resetCookies = HttpTransportSettings.SETTING_HTTP_RESET_COOKIES.get(settings);
        this.maxCompositeBufferComponents = SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.workerCount = SETTING_HTTP_WORKER_COUNT.get(settings);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.tcpNoDelay = HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.reuseAddress = HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings);
        this.tcpReceiveBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings);
        this.detailedErrorsEnabled = HttpTransportSettings.SETTING_HTTP_DETAILED_ERRORS_ENABLED.get(settings);
        this.readTimeoutMillis = Math.toIntExact(HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings).getMillis());
        ByteSizeValue receivePredictorMin = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        ByteSizeValue receivePredictorMax = SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = receivePredictorMax.getBytes() == receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator(Math.toIntExact(receivePredictorMax.getBytes())) : new AdaptiveRecvByteBufAllocator(Math.toIntExact(receivePredictorMin.getBytes()), Math.toIntExact(receivePredictorMin.getBytes()), Math.toIntExact(receivePredictorMax.getBytes()));
        this.compression = HttpTransportSettings.SETTING_HTTP_COMPRESSION.get(settings);
        this.compressionLevel = HttpTransportSettings.SETTING_HTTP_COMPRESSION_LEVEL.get(settings);
        this.pipelining = HttpTransportSettings.SETTING_PIPELINING.get(settings);
        this.pipeliningMaxEvents = HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = Netty4HttpServerTransport.buildCorsConfig(settings);
        if (maxContentLength.getBytes() > Integer.MAX_VALUE) {
            logger.warn("maxContentLength[{}] set to high value, resetting it to [100mb]", (Object)maxContentLength);
            deprecationLogger.deprecated("out of bounds max content length value [{}] will no longer be truncated to [100mb], you must enter a valid setting", maxContentLength.getStringRep());
            maxContentLength = new ByteSizeValue(100L, ByteSizeUnit.MB);
        }
        this.maxContentLength = maxContentLength;
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}->{}], max_composite_buffer_components[{}], pipelining[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictorMin, (Object)receivePredictorMax, (Object)this.maxCompositeBufferComponents, (Object)this.pipelining, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            this.serverOpenChannels = new Netty4OpenChannelsHandler(logger);
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group(new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory(this.settings, "http_server_worker")));
            this.serverBootstrap.channel(NioServerSocketChannel.class);
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings));
            ByteSizeValue tcpSendBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings);
            if (tcpSendBufferSize.getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, this.recvByteBufAllocator);
            boolean reuseAddress = HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, reuseAddress);
            this.boundAddress = this.createBoundHttpAddress();
            if (logger.isInfoEnabled()) {
                logger.info("{}", (Object)this.boundAddress);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private BoundTransportAddress createBoundHttpAddress() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = Netty4HttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), new TransportAddress(publishAddress));
    }

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ports.iterator().next().value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    static Netty4CorsConfig buildCorsConfig(Settings settings) {
        Netty4CorsConfigBuilder builder;
        if (!HttpTransportSettings.SETTING_CORS_ENABLED.get(settings).booleanValue()) {
            return Netty4CorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        if (Strings.isNullOrEmpty(origin)) {
            builder = Netty4CorsConfigBuilder.forOrigins(new String[0]);
        } else if (origin.equals("*")) {
            builder = Netty4CorsConfigBuilder.forAnyOrigin();
        } else {
            try {
                Pattern p = RestUtils.checkCorsSettingForRegex(origin);
                builder = p == null ? Netty4CorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray(origin)) : Netty4CorsConfigBuilder.forPattern(p);
            }
            catch (PatternSyntaxException e) {
                throw new SettingsException("Bad regex in [" + HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.getKey() + "]: [" + origin + "]", e);
            }
        }
        if (HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings), ",");
        HttpMethod[] methods = (HttpMethod[])Arrays.asList(strMethods).stream().map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
        return builder.allowedRequestMethods(methods).maxAge(HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings).intValue()).allowedRequestHeaders(Strings.tokenizeToStringArray(HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings), ",")).shortCircuit().build();
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                List<Channel> list = this.serverChannels;
                synchronized (list) {
                    ChannelFuture future = this.serverBootstrap.bind(new InetSocketAddress(hostAddress, portNumber)).sync();
                    this.serverChannels.add(future.channel());
                    boundSocket.set((InetSocketAddress)future.channel().localAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        List<Channel> list = this.serverChannels;
        synchronized (list) {
            if (!this.serverChannels.isEmpty()) {
                try {
                    Netty4Utils.closeChannels(this.serverChannels);
                }
                catch (IOException e) {
                    logger.trace("exception while closing channels", (Throwable)e);
                }
                this.serverChannels.clear();
            }
        }
        if (this.serverOpenChannels != null) {
            this.serverOpenChannels.close();
            this.serverOpenChannels = null;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
            this.serverBootstrap = null;
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        Netty4OpenChannelsHandler channels = this.serverOpenChannels;
        return new HttpStats(channels == null ? 0L : channels.numberOfOpenChannels(), channels == null ? 0L : channels.totalChannels());
    }

    public Netty4CorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    void dispatchRequest(RestRequest request, RestChannel channel) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.dispatcher.dispatchRequest(request, channel, threadContext);
        }
    }

    void dispatchBadRequest(RestRequest request, RestChannel channel, Throwable cause) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.dispatcher.dispatchBadRequest(request, channel, threadContext, cause);
        }
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ReadTimeoutException) {
            if (logger.isTraceEnabled()) {
                logger.trace("Read timeout [{}]", (Object)ctx.channel().remoteAddress());
            }
            ctx.channel().close();
        } else {
            if (!this.lifecycle.started()) {
                return;
            }
            if (!NetworkExceptionHelper.isCloseConnectionException(cause)) {
                logger.warn(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)ctx.channel()), cause);
                ctx.channel().close();
            } else {
                logger.debug(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)ctx.channel()), cause);
                ctx.channel().close();
            }
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.detailedErrorsEnabled, this.threadPool.getThreadContext());
    }

    static {
        Netty4Utils.setup();
        MTU = new ByteSizeValue(Long.parseLong(System.getProperty("es.net.mtu", "1500")));
        SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting<Integer>(SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS, s -> {
            ByteSizeValue maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get((Settings)s);
            long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
            long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
            return String.valueOf(maxBufferComponents);
        }, s -> Setting.parseInt(s, 2, Integer.MAX_VALUE, SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), Setting.Property.NodeScope);
        SETTING_HTTP_WORKER_COUNT = new Setting<Integer>("http.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors(s) * 2), s -> Setting.parseInt(s, 1, "http.netty.worker_count"), Setting.Property.NodeScope);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("http.netty.receive_predictor_size", new ByteSizeValue(64L, ByteSizeUnit.KB), Setting.Property.NodeScope);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("http.netty.receive_predictor_min", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope, Setting.Property.Deprecated);
        SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("http.netty.receive_predictor_max", SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope, Setting.Property.Deprecated);
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final Netty4HttpRequestHandler requestHandler;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
            this.transport = transport;
            this.requestHandler = new Netty4HttpRequestHandler(transport, detailedErrorsEnabled, threadContext);
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("openChannels", (ChannelHandler)this.transport.serverOpenChannels);
            ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler(this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            HttpRequestDecoder decoder = new HttpRequestDecoder(Math.toIntExact(this.transport.maxInitialLineLength.getBytes()), Math.toIntExact(this.transport.maxHeaderSize.getBytes()), Math.toIntExact(this.transport.maxChunkSize.getBytes()));
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            ch.pipeline().addLast("decoder", (ChannelHandler)decoder);
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(Math.toIntExact(this.transport.maxContentLength.getBytes()));
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            ch.pipeline().addLast("aggregator", (ChannelHandler)aggregator);
            if (this.transport.compression) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.transport.compressionLevel));
            }
            if (HttpTransportSettings.SETTING_CORS_ENABLED.get(this.transport.settings()).booleanValue()) {
                ch.pipeline().addLast("cors", (ChannelHandler)new Netty4CorsHandler(this.transport.getCorsConfig()));
            }
            if (this.transport.pipelining) {
                ch.pipeline().addLast("pipelining", (ChannelHandler)new HttpPipeliningHandler(logger, this.transport.pipeliningMaxEvents));
            }
            ch.pipeline().addLast("handler", (ChannelHandler)this.requestHandler);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

