/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import conductor.org.elasticsearch.index.analysis.CharFilterFactory;
import conductor.org.elasticsearch.index.analysis.CustomAnalyzer;
import conductor.org.elasticsearch.index.analysis.TokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenizerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<CustomAnalyzer> {
    private final Settings analyzerSettings;
    private final Environment environment;
    private CustomAnalyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings, Environment environment) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
        this.environment = environment;
    }

    public void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        String tokenizerName = this.analyzerSettings.get("tokenizer");
        if (tokenizerName == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] must be configured with a tokenizer");
        }
        TokenizerFactory tokenizer = tokenizers.get(tokenizerName);
        if (tokenizer == null) {
            throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find tokenizer under name [" + tokenizerName + "]");
        }
        List<String> charFilterNames = this.analyzerSettings.getAsList("char_filter");
        ArrayList<CharFilterFactory> charFiltersList = new ArrayList<CharFilterFactory>(charFilterNames.size());
        for (String charFilterName : charFilterNames) {
            CharFilterFactory charFilter = charFilters.get(charFilterName);
            if (charFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find char_filter under name [" + charFilterName + "]");
            }
            charFiltersList.add(charFilter);
        }
        int positionIncrementGap = 100;
        positionIncrementGap = this.analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = this.analyzerSettings.getAsInt("offset_gap", -1);
        List<String> tokenFilterNames = this.analyzerSettings.getAsList("filter");
        ArrayList<TokenFilterFactory> tokenFilterList = new ArrayList<TokenFilterFactory>(tokenFilterNames.size());
        for (String tokenFilterName : tokenFilterNames) {
            TokenFilterFactory tokenFilter = tokenFilters.get(tokenFilterName);
            if (tokenFilter == null) {
                throw new IllegalArgumentException("Custom Analyzer [" + this.name() + "] failed to find filter under name [" + tokenFilterName + "]");
            }
            tokenFilter = tokenFilter.getChainAwareTokenFilterFactory(tokenizer, charFiltersList, tokenFilterList, tokenFilters::get);
            tokenFilterList.add(tokenFilter);
        }
        this.customAnalyzer = new CustomAnalyzer(tokenizerName, tokenizer, charFiltersList.toArray(new CharFilterFactory[charFiltersList.size()]), tokenFilterList.toArray(new TokenFilterFactory[tokenFilterList.size()]), positionIncrementGap, offsetGap);
    }

    @Override
    public CustomAnalyzer get() {
        return this.customAnalyzer;
    }
}

