/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata;

import conductor.com.carrotsearch.hppc.ObjectLongHashMap;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.common.FieldMemoryStats;
import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.common.regex.Regex;
import conductor.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import conductor.org.elasticsearch.index.fielddata.FieldDataStats;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class ShardFieldData
implements IndexFieldDataCache.Listener {
    private final CounterMetric evictionsMetric = new CounterMetric();
    private final CounterMetric totalMetric = new CounterMetric();
    private final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    public FieldDataStats stats(String ... fields) {
        ObjectLongHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongHashMap<String>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals == null ? null : new FieldMemoryStats(fieldTotals));
    }

    @Override
    public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        this.totalMetric.inc(ramUsage.ramBytesUsed());
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
        if (total != null) {
            total.inc(ramUsage.ramBytesUsed());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.ramBytesUsed());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(fieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.ramBytesUsed());
            }
        }
    }

    @Override
    public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(fieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

