/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.composite;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.DocIdSet;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import conductor.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import java.io.IOException;

class TermsSortedDocsProducer
extends SortedDocsProducer {
    TermsSortedDocsProducer(String field) {
        super(field);
    }

    @Override
    DocIdSet processLeaf(Query query, CompositeValuesCollectorQueue queue, LeafReaderContext context, boolean fillDocIdSet) throws IOException {
        BytesRef upper;
        Terms terms = context.reader().terms(this.field);
        if (terms == null) {
            return DocIdSet.EMPTY;
        }
        BytesRef lowerValue = (BytesRef)queue.getLowerValueLeadSource();
        BytesRef upperValue = (BytesRef)queue.getUpperValueLeadSource();
        TermsEnum te = terms.iterator();
        if (lowerValue != null ? te.seekCeil(lowerValue) == TermsEnum.SeekStatus.END : te.next() == null) {
            return DocIdSet.EMPTY;
        }
        DocIdSetBuilder builder = fillDocIdSet ? new DocIdSetBuilder(context.reader().maxDoc(), terms) : null;
        PostingsEnum reuse = null;
        boolean first = true;
        BytesRef bytesRef = upper = upperValue == null ? null : BytesRef.deepCopyOf(upperValue);
        while (!(upper != null && upper.compareTo(te.term()) < 0 || this.processBucket(queue, context, reuse = te.postings(reuse, 0), te.term(), builder) && !first)) {
            first = false;
            if (te.next() != null) continue;
        }
        return fillDocIdSet ? builder.build() : DocIdSet.EMPTY;
    }
}

