/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.scripted;

import conductor.org.elasticsearch.common.util.CollectionUtils;
import conductor.org.elasticsearch.script.Script;
import conductor.org.elasticsearch.script.ScriptedMetricAggContexts;
import conductor.org.elasticsearch.search.SearchParseException;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.lookup.SearchLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptedMetricAggregatorFactory
extends AggregatorFactory<ScriptedMetricAggregatorFactory> {
    private final ScriptedMetricAggContexts.MapScript.Factory mapScript;
    private final Map<String, Object> mapScriptParams;
    private final ScriptedMetricAggContexts.CombineScript.Factory combineScript;
    private final Map<String, Object> combineScriptParams;
    private final Script reduceScript;
    private final Map<String, Object> aggParams;
    private final SearchLookup lookup;
    private final ScriptedMetricAggContexts.InitScript.Factory initScript;
    private final Map<String, Object> initScriptParams;

    public ScriptedMetricAggregatorFactory(String name, ScriptedMetricAggContexts.MapScript.Factory mapScript, Map<String, Object> mapScriptParams, ScriptedMetricAggContexts.InitScript.Factory initScript, Map<String, Object> initScriptParams, ScriptedMetricAggContexts.CombineScript.Factory combineScript, Map<String, Object> combineScriptParams, Script reduceScript, Map<String, Object> aggParams, SearchLookup lookup, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.mapScript = mapScript;
        this.mapScriptParams = mapScriptParams;
        this.initScript = initScript;
        this.initScriptParams = initScriptParams;
        this.combineScript = combineScript;
        this.combineScriptParams = combineScriptParams;
        this.reduceScript = reduceScript;
        this.lookup = lookup;
        this.aggParams = aggParams;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return ScriptedMetricAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        Map<String, Object> aggParams = this.aggParams;
        aggParams = aggParams != null ? ScriptedMetricAggregatorFactory.deepCopyParams(aggParams, this.context) : new HashMap<String, Object>();
        Object aggState = new HashMap();
        if (!aggParams.containsKey("_agg")) {
            aggParams.put("_agg", aggState);
        } else {
            aggState = aggParams.get("_agg");
        }
        ScriptedMetricAggContexts.InitScript initScript = this.initScript.newInstance(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.initScriptParams), aggState);
        ScriptedMetricAggContexts.MapScript.LeafFactory mapScript = this.mapScript.newFactory(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.mapScriptParams), aggState, this.lookup);
        ScriptedMetricAggContexts.CombineScript combineScript = this.combineScript.newInstance(ScriptedMetricAggregatorFactory.mergeParams(aggParams, this.combineScriptParams), aggState);
        Script reduceScript = ScriptedMetricAggregatorFactory.deepCopyScript(this.reduceScript, this.context);
        if (initScript != null) {
            initScript.execute();
            CollectionUtils.ensureNoSelfReferences(aggState);
        }
        return new ScriptedMetricAggregator(this.name, mapScript, combineScript, reduceScript, aggState, this.context, parent, pipelineAggregators, metaData);
    }

    private static Script deepCopyScript(Script script, SearchContext context) {
        if (script != null) {
            Map<String, Object> params = script.getParams();
            if (params != null) {
                params = ScriptedMetricAggregatorFactory.deepCopyParams(params, context);
            }
            return new Script(script.getType(), script.getLang(), script.getIdOrCode(), params);
        }
        return null;
    }

    private static <T> T deepCopyParams(T original, SearchContext context) {
        Object clone;
        if (original instanceof Map) {
            Map originalMap = (Map)original;
            HashMap clonedMap = new HashMap();
            for (Map.Entry e : originalMap.entrySet()) {
                clonedMap.put(ScriptedMetricAggregatorFactory.deepCopyParams(e.getKey(), context), ScriptedMetricAggregatorFactory.deepCopyParams(e.getValue(), context));
            }
            clone = clonedMap;
        } else if (original instanceof List) {
            List originalList = (List)original;
            ArrayList clonedList = new ArrayList();
            for (Object o : originalList) {
                clonedList.add(ScriptedMetricAggregatorFactory.deepCopyParams(o, context));
            }
            clone = clonedList;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
            clone = original;
        } else {
            throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
        }
        return clone;
    }

    private static Map<String, Object> mergeParams(Map<String, Object> agg, Map<String, Object> script) {
        HashMap<String, Object> combined = new HashMap<String, Object>(script);
        for (Map.Entry<String, Object> aggEntry : agg.entrySet()) {
            if (combined.putIfAbsent(aggEntry.getKey(), aggEntry.getValue()) == null) continue;
            throw new IllegalArgumentException("Parameter name \"" + aggEntry.getKey() + "\" used in both aggregation and script parameters");
        }
        return combined;
    }
}

