/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.http.impl.io;

import conductor.org.apache.http.ConnectionClosedException;
import conductor.org.apache.http.HttpException;
import conductor.org.apache.http.HttpRequest;
import conductor.org.apache.http.HttpRequestFactory;
import conductor.org.apache.http.ParseException;
import conductor.org.apache.http.RequestLine;
import conductor.org.apache.http.config.MessageConstraints;
import conductor.org.apache.http.impl.DefaultHttpRequestFactory;
import conductor.org.apache.http.impl.io.AbstractMessageParser;
import conductor.org.apache.http.io.SessionInputBuffer;
import conductor.org.apache.http.message.LineParser;
import conductor.org.apache.http.message.ParserCursor;
import conductor.org.apache.http.params.HttpParams;
import conductor.org.apache.http.util.Args;
import conductor.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

