/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.cjk;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CharArraySet;
import conductor.org.apache.lucene.analysis.LowerCaseFilter;
import conductor.org.apache.lucene.analysis.StopFilter;
import conductor.org.apache.lucene.analysis.StopwordAnalyzerBase;
import conductor.org.apache.lucene.analysis.TokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.cjk.CJKBigramFilter;
import conductor.org.apache.lucene.analysis.cjk.CJKWidthFilter;
import conductor.org.apache.lucene.analysis.standard.StandardTokenizer;
import java.io.IOException;

public final class CJKAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public CJKAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public CJKAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new CJKWidthFilter(source);
        result = new LowerCaseFilter(result);
        result = new CJKBigramFilter(result);
        return new Analyzer.TokenStreamComponents(source, new StopFilter(result, this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new CJKWidthFilter(in);
        result = new LowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = CJKAnalyzer.loadStopwordSet(false, CJKAnalyzer.class, CJKAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

