/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.tasks.get;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.action.ValidateActions;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.tasks.TaskId;
import java.io.IOException;

public class GetTaskRequest
extends ActionRequest {
    private TaskId taskId = TaskId.EMPTY_TASK_ID;
    private boolean waitForCompletion = false;
    private TimeValue timeout = null;

    public TaskId getTaskId() {
        return this.taskId;
    }

    public GetTaskRequest setTaskId(TaskId taskId) {
        this.taskId = taskId;
        return this;
    }

    public boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public GetTaskRequest setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public GetTaskRequest setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    GetTaskRequest nodeRequest(String thisNodeId, long thisTaskId) {
        GetTaskRequest copy = new GetTaskRequest();
        copy.setParentTask(thisNodeId, thisTaskId);
        copy.setTaskId(this.taskId);
        copy.setTimeout(this.timeout);
        copy.setWaitForCompletion(this.waitForCompletion);
        return copy;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.getTaskId().isSet()) {
            validationException = ValidateActions.addValidationError("task id is required", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.taskId = TaskId.readFromStream(in);
        this.timeout = in.readOptionalTimeValue();
        this.waitForCompletion = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.taskId.writeTo(out);
        out.writeOptionalTimeValue(this.timeout);
        out.writeBoolean(this.waitForCompletion);
    }
}

