/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.XPackRequestConverters;
import conductor.org.elasticsearch.client.xpack.XPackInfoRequest;
import conductor.org.elasticsearch.client.xpack.XPackInfoResponse;
import conductor.org.elasticsearch.client.xpack.XPackUsageRequest;
import conductor.org.elasticsearch.client.xpack.XPackUsageResponse;
import java.io.IOException;
import java.util.Collections;

public final class XPackClient {
    private final RestHighLevelClient restHighLevelClient;

    XPackClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public XPackInfoResponse info(XPackInfoRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, XPackRequestConverters::info, options, XPackInfoResponse::fromXContent, Collections.emptySet());
    }

    public void infoAsync(XPackInfoRequest request, RequestOptions options, ActionListener<XPackInfoResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, XPackRequestConverters::info, options, XPackInfoResponse::fromXContent, listener, Collections.emptySet());
    }

    public XPackUsageResponse usage(XPackUsageRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, XPackRequestConverters::usage, options, XPackUsageResponse::fromXContent, Collections.emptySet());
    }

    public void usageAsync(XPackUsageRequest request, RequestOptions options, ActionListener<XPackUsageResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, XPackRequestConverters::usage, options, XPackUsageResponse::fromXContent, listener, Collections.emptySet());
    }
}

