/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indexlifecycle;

import conductor.org.elasticsearch.client.indexlifecycle.PhaseExecutionInfo;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.bytes.BytesArray;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.common.xcontent.json.JsonXContent;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;

public class IndexLifecycleExplainResponse
implements ToXContentObject {
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField MANAGED_BY_ILM_FIELD = new ParseField("managed", new String[0]);
    private static final ParseField POLICY_NAME_FIELD = new ParseField("policy", new String[0]);
    private static final ParseField LIFECYCLE_DATE_MILLIS_FIELD = new ParseField("lifecycle_date_millis", new String[0]);
    private static final ParseField LIFECYCLE_DATE_FIELD = new ParseField("lifecycle_date", new String[0]);
    private static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
    private static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
    private static final ParseField STEP_FIELD = new ParseField("step", new String[0]);
    private static final ParseField FAILED_STEP_FIELD = new ParseField("failed_step", new String[0]);
    private static final ParseField PHASE_TIME_MILLIS_FIELD = new ParseField("phase_time_millis", new String[0]);
    private static final ParseField PHASE_TIME_FIELD = new ParseField("phase_time", new String[0]);
    private static final ParseField ACTION_TIME_MILLIS_FIELD = new ParseField("action_time_millis", new String[0]);
    private static final ParseField ACTION_TIME_FIELD = new ParseField("action_time", new String[0]);
    private static final ParseField STEP_TIME_MILLIS_FIELD = new ParseField("step_time_millis", new String[0]);
    private static final ParseField STEP_TIME_FIELD = new ParseField("step_time", new String[0]);
    private static final ParseField STEP_INFO_FIELD = new ParseField("step_info", new String[0]);
    private static final ParseField PHASE_EXECUTION_INFO = new ParseField("phase_execution", new String[0]);
    public static final ConstructingObjectParser<IndexLifecycleExplainResponse, Void> PARSER = new ConstructingObjectParser("index_lifecycle_explain_response", true, a -> new IndexLifecycleExplainResponse((String)a[0], (Boolean)a[1], (String)a[2], (Long)a[3], (String)a[4], (String)a[5], (String)a[6], (String)a[7], (Long)a[8], (Long)a[9], (Long)a[10], (BytesReference)a[11], (PhaseExecutionInfo)a[12]));
    private final String index;
    private final String policyName;
    private final String phase;
    private final String action;
    private final String step;
    private final String failedStep;
    private final Long lifecycleDate;
    private final Long phaseTime;
    private final Long actionTime;
    private final Long stepTime;
    private final boolean managedByILM;
    private final BytesReference stepInfo;
    private final PhaseExecutionInfo phaseExecutionInfo;

    public static IndexLifecycleExplainResponse newManagedIndexResponse(String index, String policyName, Long lifecycleDate, String phase, String action, String step, String failedStep, Long phaseTime, Long actionTime, Long stepTime, BytesReference stepInfo, PhaseExecutionInfo phaseExecutionInfo) {
        return new IndexLifecycleExplainResponse(index, true, policyName, lifecycleDate, phase, action, step, failedStep, phaseTime, actionTime, stepTime, stepInfo, phaseExecutionInfo);
    }

    public static IndexLifecycleExplainResponse newUnmanagedIndexResponse(String index) {
        return new IndexLifecycleExplainResponse(index, false, null, null, null, null, null, null, null, null, null, null, null);
    }

    private IndexLifecycleExplainResponse(String index, boolean managedByILM, String policyName, Long lifecycleDate, String phase, String action, String step, String failedStep, Long phaseTime, Long actionTime, Long stepTime, BytesReference stepInfo, PhaseExecutionInfo phaseExecutionInfo) {
        if (managedByILM) {
            if (policyName == null) {
                throw new IllegalArgumentException("[" + POLICY_NAME_FIELD.getPreferredName() + "] cannot be null for managed index");
            }
            long numNull = Stream.of(phase, action, step).filter(Objects::isNull).count();
            if (numNull > 0L && numNull < 3L) {
                throw new IllegalArgumentException("managed index response must have complete step details [" + PHASE_FIELD.getPreferredName() + "=" + phase + ", " + ACTION_FIELD.getPreferredName() + "=" + action + ", " + STEP_FIELD.getPreferredName() + "=" + step + "]");
            }
        } else if (policyName != null || lifecycleDate != null || phase != null || action != null || step != null || failedStep != null || phaseTime != null || actionTime != null || stepTime != null || stepInfo != null || phaseExecutionInfo != null) {
            throw new IllegalArgumentException("Unmanaged index response must only contain fields: [" + MANAGED_BY_ILM_FIELD + ", " + INDEX_FIELD + "]");
        }
        this.index = index;
        this.policyName = policyName;
        this.managedByILM = managedByILM;
        this.lifecycleDate = lifecycleDate;
        this.phase = phase;
        this.action = action;
        this.step = step;
        this.phaseTime = phaseTime;
        this.actionTime = actionTime;
        this.stepTime = stepTime;
        this.failedStep = failedStep;
        this.stepInfo = stepInfo;
        this.phaseExecutionInfo = phaseExecutionInfo;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean managedByILM() {
        return this.managedByILM;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public long getLifecycleDate() {
        return this.lifecycleDate;
    }

    public String getPhase() {
        return this.phase;
    }

    public long getPhaseTime() {
        return this.phaseTime;
    }

    public String getAction() {
        return this.action;
    }

    public long getActionTime() {
        return this.actionTime;
    }

    public String getStep() {
        return this.step;
    }

    public long getStepTime() {
        return this.stepTime;
    }

    public String getFailedStep() {
        return this.failedStep;
    }

    public BytesReference getStepInfo() {
        return this.stepInfo;
    }

    public PhaseExecutionInfo getPhaseExecutionInfo() {
        return this.phaseExecutionInfo;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD.getPreferredName(), this.index);
        builder.field(MANAGED_BY_ILM_FIELD.getPreferredName(), this.managedByILM);
        if (this.managedByILM) {
            builder.field(POLICY_NAME_FIELD.getPreferredName(), this.policyName);
            if (this.lifecycleDate != null) {
                builder.timeField(LIFECYCLE_DATE_MILLIS_FIELD.getPreferredName(), LIFECYCLE_DATE_FIELD.getPreferredName(), this.lifecycleDate);
            }
            if (this.phase != null) {
                builder.field(PHASE_FIELD.getPreferredName(), this.phase);
            }
            if (this.phaseTime != null) {
                builder.timeField(PHASE_TIME_MILLIS_FIELD.getPreferredName(), PHASE_TIME_FIELD.getPreferredName(), this.phaseTime);
            }
            if (this.action != null) {
                builder.field(ACTION_FIELD.getPreferredName(), this.action);
            }
            if (this.actionTime != null) {
                builder.timeField(ACTION_TIME_MILLIS_FIELD.getPreferredName(), ACTION_TIME_FIELD.getPreferredName(), this.actionTime);
            }
            if (this.step != null) {
                builder.field(STEP_FIELD.getPreferredName(), this.step);
            }
            if (this.stepTime != null) {
                builder.timeField(STEP_TIME_MILLIS_FIELD.getPreferredName(), STEP_TIME_FIELD.getPreferredName(), this.stepTime);
            }
            if (Strings.hasLength(this.failedStep)) {
                builder.field(FAILED_STEP_FIELD.getPreferredName(), this.failedStep);
            }
            if (this.stepInfo != null && this.stepInfo.length() > 0) {
                builder.rawField(STEP_INFO_FIELD.getPreferredName(), this.stepInfo.streamInput(), XContentType.JSON);
            }
            if (this.phaseExecutionInfo != null) {
                builder.field(PHASE_EXECUTION_INFO.getPreferredName(), this.phaseExecutionInfo);
            }
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.managedByILM, this.policyName, this.lifecycleDate, this.phase, this.action, this.step, this.failedStep, this.phaseTime, this.actionTime, this.stepTime, this.stepInfo, this.phaseExecutionInfo);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndexLifecycleExplainResponse other = (IndexLifecycleExplainResponse)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.managedByILM, other.managedByILM) && Objects.equals(this.policyName, other.policyName) && Objects.equals(this.lifecycleDate, other.lifecycleDate) && Objects.equals(this.phase, other.phase) && Objects.equals(this.action, other.action) && Objects.equals(this.step, other.step) && Objects.equals(this.failedStep, other.failedStep) && Objects.equals(this.phaseTime, other.phaseTime) && Objects.equals(this.actionTime, other.actionTime) && Objects.equals(this.stepTime, other.stepTime) && Objects.equals(this.stepInfo, other.stepInfo) && Objects.equals(this.phaseExecutionInfo, other.phaseExecutionInfo);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), MANAGED_BY_ILM_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), POLICY_NAME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LIFECYCLE_DATE_MILLIS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PHASE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ACTION_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), STEP_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILED_STEP_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PHASE_TIME_MILLIS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ACTION_TIME_MILLIS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), STEP_TIME_MILLIS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.copyCurrentStructure(p);
            return BytesArray.bytes(builder);
        }, STEP_INFO_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PhaseExecutionInfo.parse(p, ""), PHASE_EXECUTION_INFO);
    }
}

