/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.routing.allocation;

import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import conductor.org.elasticsearch.cluster.routing.RecoverySource;
import conductor.org.elasticsearch.cluster.routing.RoutingChangesObserver;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.routing.ShardRouting;
import conductor.org.elasticsearch.cluster.routing.UnassignedInfo;
import conductor.org.elasticsearch.cluster.routing.allocation.StaleShard;
import conductor.org.elasticsearch.common.util.set.Sets;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.shard.ShardId;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IndexMetaDataUpdater
extends RoutingChangesObserver.AbstractRoutingChangesObserver {
    private final Map<ShardId, Updates> shardChanges = new HashMap<ShardId, Updates>();

    @Override
    public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
        assert (!initializedShard.isRelocationTarget()) : "shardInitialized is not called on relocation target: " + initializedShard;
        if (initializedShard.primary()) {
            this.increasePrimaryTerm(initializedShard.shardId());
            Updates updates = this.changes(initializedShard.shardId());
            assert (updates.initializedPrimary == null) : "Primary cannot be initialized more than once in same allocation round: (previous: " + Updates.access$000(updates) + ", next: " + initializedShard + ")";
            updates.initializedPrimary = initializedShard;
        }
    }

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        assert (Objects.equals(initializingShard.allocationId().getId(), startedShard.allocationId().getId())) : "initializingShard.allocationId [" + initializingShard.allocationId().getId() + "] and startedShard.allocationId [" + startedShard.allocationId().getId() + "] have to have the same";
        Updates updates = this.changes(startedShard.shardId());
        updates.addedAllocationIds.add(startedShard.allocationId().getId());
        if (startedShard.primary() && initializingShard.recoverySource() == RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE) {
            updates.removedAllocationIds.add("_forced_allocation_");
        }
    }

    @Override
    public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
        if (failedShard.active() && failedShard.primary()) {
            Updates updates = this.changes(failedShard.shardId());
            if (updates.firstFailedPrimary == null) {
                updates.firstFailedPrimary = failedShard;
            }
            this.increasePrimaryTerm(failedShard.shardId());
        }
    }

    @Override
    public void relocationCompleted(ShardRouting removedRelocationSource) {
        this.removeAllocationId(removedRelocationSource);
    }

    public MetaData applyChanges(MetaData oldMetaData, RoutingTable newRoutingTable) {
        Map<Index, List<Map.Entry>> changesGroupedByIndex = this.shardChanges.entrySet().stream().collect(Collectors.groupingBy(e -> ((ShardId)e.getKey()).getIndex()));
        MetaData.Builder metaDataBuilder = null;
        for (Map.Entry<Index, List<Map.Entry>> indexChanges : changesGroupedByIndex.entrySet()) {
            Index index = indexChanges.getKey();
            IndexMetaData oldIndexMetaData = oldMetaData.getIndexSafe(index);
            IndexMetaData.Builder indexMetaDataBuilder = null;
            for (Map.Entry shardEntry : indexChanges.getValue()) {
                ShardId shardId = (ShardId)shardEntry.getKey();
                Updates updates = (Updates)shardEntry.getValue();
                indexMetaDataBuilder = this.updateInSyncAllocations(newRoutingTable, oldIndexMetaData, indexMetaDataBuilder, shardId, updates);
                indexMetaDataBuilder = this.updatePrimaryTerm(oldIndexMetaData, indexMetaDataBuilder, shardId, updates);
            }
            if (indexMetaDataBuilder == null) continue;
            if (metaDataBuilder == null) {
                metaDataBuilder = MetaData.builder(oldMetaData);
            }
            metaDataBuilder.put(indexMetaDataBuilder);
        }
        if (metaDataBuilder != null) {
            return metaDataBuilder.build();
        }
        return oldMetaData;
    }

    private IndexMetaData.Builder updateInSyncAllocations(RoutingTable newRoutingTable, IndexMetaData oldIndexMetaData, IndexMetaData.Builder indexMetaDataBuilder, ShardId shardId, Updates updates) {
        assert (Sets.haveEmptyIntersection(updates.addedAllocationIds, updates.removedAllocationIds)) : "allocation ids cannot be both added and removed in the same allocation round, added ids: " + Updates.access$100(updates) + ", removed ids: " + Updates.access$200(updates);
        Set<String> oldInSyncAllocationIds = oldIndexMetaData.inSyncAllocationIds(shardId.id());
        if (updates.initializedPrimary != null && !oldInSyncAllocationIds.isEmpty() && !oldInSyncAllocationIds.contains(updates.initializedPrimary.allocationId().getId())) {
            boolean emptyPrimary;
            RecoverySource recoverySource = updates.initializedPrimary.recoverySource();
            RecoverySource.Type recoverySourceType = recoverySource.getType();
            boolean bl = emptyPrimary = recoverySourceType == RecoverySource.Type.EMPTY_STORE;
            assert (updates.addedAllocationIds.isEmpty()) : (emptyPrimary ? "empty" : "stale") + " primary is not force-initialized in same allocation round where shards are started";
            if (indexMetaDataBuilder == null) {
                indexMetaDataBuilder = IndexMetaData.builder(oldIndexMetaData);
            }
            if (emptyPrimary) {
                indexMetaDataBuilder.putInSyncAllocationIds(shardId.id(), Collections.emptySet());
            } else {
                String allocationId;
                if (recoverySource == RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE) {
                    allocationId = "_forced_allocation_";
                } else {
                    assert (recoverySource instanceof RecoverySource.SnapshotRecoverySource) : recoverySource;
                    allocationId = updates.initializedPrimary.allocationId().getId();
                }
                indexMetaDataBuilder.putInSyncAllocationIds(shardId.id(), Collections.singleton(allocationId));
            }
        } else {
            Set<String> inSyncAllocationIds = new HashSet<String>(oldInSyncAllocationIds);
            inSyncAllocationIds.addAll(updates.addedAllocationIds);
            inSyncAllocationIds.removeAll(updates.removedAllocationIds);
            assert (!oldInSyncAllocationIds.contains("_forced_allocation_") || !inSyncAllocationIds.contains("_forced_allocation_")) : "fake allocation id has to be removed, inSyncAllocationIds:" + inSyncAllocationIds;
            int maxActiveShards = oldIndexMetaData.getNumberOfReplicas() + 1;
            IndexShardRoutingTable newShardRoutingTable = newRoutingTable.shardRoutingTable(shardId);
            if (inSyncAllocationIds.size() > oldInSyncAllocationIds.size() && inSyncAllocationIds.size() > maxActiveShards) {
                List<ShardRouting> assignedShards = newShardRoutingTable.assignedShards();
                assert (assignedShards.size() <= maxActiveShards) : "cannot have more assigned shards " + assignedShards + " than maximum possible active shards " + maxActiveShards;
                Set assignedAllocations = assignedShards.stream().map(s -> s.allocationId().getId()).collect(Collectors.toSet());
                inSyncAllocationIds = inSyncAllocationIds.stream().sorted(Comparator.comparing(assignedAllocations::contains).reversed()).limit(maxActiveShards).collect(Collectors.toSet());
            }
            if (newShardRoutingTable.activeShards().isEmpty() && updates.firstFailedPrimary != null) {
                inSyncAllocationIds.add(updates.firstFailedPrimary.allocationId().getId());
            }
            assert (!inSyncAllocationIds.isEmpty() || oldInSyncAllocationIds.isEmpty()) : "in-sync allocations cannot become empty after they have been non-empty: " + oldInSyncAllocationIds;
            if (!inSyncAllocationIds.isEmpty()) {
                if (indexMetaDataBuilder == null) {
                    indexMetaDataBuilder = IndexMetaData.builder(oldIndexMetaData);
                }
                indexMetaDataBuilder.putInSyncAllocationIds(shardId.id(), inSyncAllocationIds);
            }
        }
        return indexMetaDataBuilder;
    }

    public static ClusterState removeStaleIdsWithoutRoutings(ClusterState clusterState, List<StaleShard> staleShards, Logger logger) {
        MetaData oldMetaData = clusterState.metaData();
        RoutingTable oldRoutingTable = clusterState.routingTable();
        MetaData.Builder metaDataBuilder = null;
        for (Map.Entry<Index, List<StaleShard>> indexEntry : staleShards.stream().collect(Collectors.groupingBy(fs -> fs.getShardId().getIndex())).entrySet()) {
            IndexMetaData oldIndexMetaData = oldMetaData.getIndexSafe(indexEntry.getKey());
            IndexMetaData.Builder indexMetaDataBuilder = null;
            for (Map.Entry<ShardId, List<StaleShard>> shardEntry : indexEntry.getValue().stream().collect(Collectors.groupingBy(staleShard -> staleShard.getShardId())).entrySet()) {
                int shardNumber = shardEntry.getKey().getId();
                Set<String> oldInSyncAllocations = oldIndexMetaData.inSyncAllocationIds(shardNumber);
                Set idsToRemove = shardEntry.getValue().stream().map(e -> e.getAllocationId()).collect(Collectors.toSet());
                assert (idsToRemove.stream().allMatch(id -> oldRoutingTable.getByAllocationId((ShardId)shardEntry.getKey(), (String)id) == null)) : "removing stale ids: " + idsToRemove + ", some of which have still a routing entry: " + oldRoutingTable;
                Set<String> remainingInSyncAllocations = Sets.difference(oldInSyncAllocations, idsToRemove);
                assert (!remainingInSyncAllocations.isEmpty()) : "Set of in-sync ids cannot become empty for shard " + shardEntry.getKey() + " (before: " + oldInSyncAllocations + ", ids to remove: " + idsToRemove + ")";
                if (!remainingInSyncAllocations.isEmpty()) {
                    if (indexMetaDataBuilder == null) {
                        indexMetaDataBuilder = IndexMetaData.builder(oldIndexMetaData);
                    }
                    indexMetaDataBuilder.putInSyncAllocationIds(shardNumber, remainingInSyncAllocations);
                }
                logger.warn("{} marking unavailable shards as stale: {}", (Object)shardEntry.getKey(), (Object)idsToRemove);
            }
            if (indexMetaDataBuilder == null) continue;
            if (metaDataBuilder == null) {
                metaDataBuilder = MetaData.builder(oldMetaData);
            }
            metaDataBuilder.put(indexMetaDataBuilder);
        }
        if (metaDataBuilder != null) {
            return ClusterState.builder(clusterState).metaData(metaDataBuilder).build();
        }
        return clusterState;
    }

    private IndexMetaData.Builder updatePrimaryTerm(IndexMetaData oldIndexMetaData, IndexMetaData.Builder indexMetaDataBuilder, ShardId shardId, Updates updates) {
        if (updates.increaseTerm) {
            if (indexMetaDataBuilder == null) {
                indexMetaDataBuilder = IndexMetaData.builder(oldIndexMetaData);
            }
            indexMetaDataBuilder.primaryTerm(shardId.id(), oldIndexMetaData.primaryTerm(shardId.id()) + 1L);
        }
        return indexMetaDataBuilder;
    }

    private Updates changes(ShardId shardId) {
        return this.shardChanges.computeIfAbsent(shardId, k -> new Updates());
    }

    void removeAllocationId(ShardRouting shardRouting) {
        if (shardRouting.active()) {
            this.changes(shardRouting.shardId()).removedAllocationIds.add(shardRouting.allocationId().getId());
        }
    }

    private void increasePrimaryTerm(ShardId shardId) {
        this.changes(shardId).increaseTerm = true;
    }

    private static class Updates {
        private boolean increaseTerm;
        private Set<String> addedAllocationIds = new HashSet<String>();
        private Set<String> removedAllocationIds = new HashSet<String>();
        private ShardRouting initializedPrimary = null;
        private ShardRouting firstFailedPrimary = null;

        private Updates() {
        }
    }
}

