/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject;

import conductor.org.elasticsearch.common.inject.InjectorImpl;
import conductor.org.elasticsearch.common.inject.Key;
import conductor.org.elasticsearch.common.inject.LookupProcessor;
import conductor.org.elasticsearch.common.inject.Lookups;
import conductor.org.elasticsearch.common.inject.MembersInjector;
import conductor.org.elasticsearch.common.inject.Provider;
import conductor.org.elasticsearch.common.inject.TypeLiteral;
import conductor.org.elasticsearch.common.inject.internal.Errors;
import conductor.org.elasticsearch.common.inject.spi.Element;
import conductor.org.elasticsearch.common.inject.spi.MembersInjectorLookup;
import conductor.org.elasticsearch.common.inject.spi.ProviderLookup;
import java.util.ArrayList;
import java.util.List;

class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = new ArrayList<Element>();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    public void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

