/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.inject.internal;

import conductor.org.elasticsearch.common.inject.Binder;
import conductor.org.elasticsearch.common.inject.Injector;
import conductor.org.elasticsearch.common.inject.Key;
import conductor.org.elasticsearch.common.inject.internal.BindingImpl;
import conductor.org.elasticsearch.common.inject.internal.InternalFactory;
import conductor.org.elasticsearch.common.inject.internal.Scoping;
import conductor.org.elasticsearch.common.inject.internal.ToStringBuilder;
import conductor.org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import conductor.org.elasticsearch.common.inject.spi.Dependency;
import conductor.org.elasticsearch.common.inject.spi.ExposedBinding;
import conductor.org.elasticsearch.common.inject.spi.PrivateElements;
import java.util.Collections;
import java.util.Set;

public class ExposedBindingImpl<T>
extends BindingImpl<T>
implements ExposedBinding<T> {
    private final PrivateElements privateElements;

    public ExposedBindingImpl(Injector injector, Object source, Key<T> key, InternalFactory<T> factory, PrivateElements privateElements) {
        super(injector, key, source, factory, Scoping.UNSCOPED);
        this.privateElements = privateElements;
    }

    public ExposedBindingImpl(Object source, Key<T> key, Scoping scoping, PrivateElements privateElements) {
        super(source, key, scoping);
        this.privateElements = privateElements;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Collections.singleton(Dependency.get(Key.get(Injector.class)));
    }

    @Override
    public PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new ExposedBindingImpl(this.getSource(), this.getKey(), scoping, this.privateElements);
    }

    @Override
    public ExposedBindingImpl<T> withKey(Key<T> key) {
        return new ExposedBindingImpl<T>(this.getSource(), key, this.getScoping(), this.privateElements);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ExposedBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("privateElements", this.privateElements).toString();
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }
}

