/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.IndexableField;
import conductor.org.apache.lucene.index.IndexableFieldType;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.MatchAllDocsQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.apache.lucene.search.TermInSetQuery;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.lucene.BytesRefs;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.fielddata.AtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import conductor.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import conductor.org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.MetadataFieldMapper;
import conductor.org.elasticsearch.index.mapper.ParseContext;
import conductor.org.elasticsearch.index.mapper.TermBasedFieldType;
import conductor.org.elasticsearch.index.mapper.Uid;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.search.MultiValueMode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class IdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";

    private static AtomicFieldData wrap(final AtomicFieldData in) {
        return new AtomicFieldData(){

            @Override
            public void close() {
                in.close();
            }

            @Override
            public long ramBytesUsed() {
                return in.ramBytesUsed();
            }

            @Override
            public ScriptDocValues<?> getScriptValues() {
                return new ScriptDocValues.Strings(this.getBytesValues());
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                final SortedBinaryDocValues inValues = in.getBytesValues();
                return new SortedBinaryDocValues(){

                    @Override
                    public BytesRef nextValue() throws IOException {
                        BytesRef encoded = inValues.nextValue();
                        return new BytesRef(Uid.decodeId(Arrays.copyOfRange(encoded.bytes, encoded.offset, encoded.offset + encoded.length)));
                    }

                    @Override
                    public int docValueCount() {
                        int count = inValues.docValueCount();
                        assert (count == 1);
                        return inValues.docValueCount();
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return inValues.advanceExact(doc);
                    }
                };
            }
        };
    }

    static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        if (indexSettings.isSingleType()) {
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setStored(true);
        } else {
            defaultFieldType.setIndexOptions(IndexOptions.NONE);
            defaultFieldType.setStored(false);
        }
        return defaultFieldType;
    }

    private IdFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? IdFieldMapper.defaultFieldType(indexSettings) : existing, indexSettings);
    }

    private IdFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_id", fieldType, IdFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            if (context.mapperService().getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_6_0_0_beta1)) {
                BytesRef id = Uid.encodeId(context.sourceToParse().id());
                fields.add(new Field("_id", id, (IndexableFieldType)this.fieldType));
            } else {
                fields.add(new Field("_id", context.sourceToParse().id(), (IndexableFieldType)this.fieldType));
            }
        }
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class IdFieldType
    extends TermBasedFieldType {
        IdFieldType() {
        }

        protected IdFieldType(IdFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IdFieldType(this);
        }

        @Override
        public String typeName() {
            return "_id";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            if (this.indexOptions() != IndexOptions.NONE) {
                this.failIfNotIndexed();
                BytesRef[] bytesRefs = new BytesRef[values.size()];
                boolean is5xIndex = context.indexVersionCreated().before(Version.V_6_0_0_beta1);
                for (int i = 0; i < bytesRefs.length; ++i) {
                    BytesRef id;
                    if (is5xIndex) {
                        id = BytesRefs.toBytesRef(values.get(i));
                    } else {
                        Object idObject = values.get(i);
                        if (idObject instanceof BytesRef) {
                            idObject = ((BytesRef)idObject).utf8ToString();
                        }
                        id = Uid.encodeId(idObject.toString());
                    }
                    bytesRefs[i] = id;
                }
                return new TermInSetQuery(this.name(), bytesRefs);
            }
            return new TermInSetQuery("_uid", Uid.createUidsForTypesAndIds(context.queryTypes(), values));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            if (this.indexOptions() == IndexOptions.NONE) {
                throw new IllegalArgumentException("Fielddata access on the _id field is disallowed");
            }
            final PagedBytesIndexFieldData.Builder fieldDataBuilder = new PagedBytesIndexFieldData.Builder(0.0, 2.147483647E9, 0);
            return new IndexFieldData.Builder(){

                @Override
                public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                    final IndexFieldData<?> fieldData = fieldDataBuilder.build(indexSettings, fieldType, cache, breakerService, mapperService);
                    if (indexSettings.getIndexVersionCreated().before(Version.V_6_0_0_beta1)) {
                        return fieldData;
                    }
                    return new IndexFieldData<AtomicFieldData>(){

                        @Override
                        public Index index() {
                            return fieldData.index();
                        }

                        @Override
                        public String getFieldName() {
                            return fieldData.getFieldName();
                        }

                        @Override
                        public AtomicFieldData load(LeafReaderContext context) {
                            return IdFieldMapper.wrap(fieldData.load(context));
                        }

                        @Override
                        public AtomicFieldData loadDirect(LeafReaderContext context) throws Exception {
                            return IdFieldMapper.wrap(fieldData.loadDirect(context));
                        }

                        @Override
                        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
                            return new SortField(this.getFieldName(), source, reverse);
                        }

                        @Override
                        public void clear() {
                            fieldData.clear();
                        }
                    };
                }
            };
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_id is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new IdFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_id";
        public static final MappedFieldType FIELD_TYPE = new IdFieldType();
        public static final MappedFieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_id");
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = FIELD_TYPE.clone();
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

