/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.rest.action.admin.indices;

import conductor.org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import conductor.org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import conductor.org.elasticsearch.action.support.IndicesOptions;
import conductor.org.elasticsearch.client.node.NodeClient;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.rest.BaseRestHandler;
import conductor.org.elasticsearch.rest.RestChannel;
import conductor.org.elasticsearch.rest.RestController;
import conductor.org.elasticsearch.rest.RestRequest;
import conductor.org.elasticsearch.rest.action.RestToXContentListener;
import java.io.IOException;

public class RestIndicesSegmentsAction
extends BaseRestHandler {
    public RestIndicesSegmentsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_segments", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_segments", this);
    }

    @Override
    public String getName() {
        return "indices_segments_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesSegmentsRequest indicesSegmentsRequest = new IndicesSegmentsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesSegmentsRequest.verbose(request.paramAsBoolean("verbose", false));
        indicesSegmentsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesSegmentsRequest.indicesOptions()));
        return channel -> client.admin().indices().segments(indicesSegmentsRequest, new RestToXContentListener<IndicesSegmentResponse>((RestChannel)channel));
    }
}

