/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.codecs.lucene50;

import conductor.org.apache.lucene.codecs.CodecUtil;
import conductor.org.apache.lucene.codecs.LiveDocsFormat;
import conductor.org.apache.lucene.index.CorruptIndexException;
import conductor.org.apache.lucene.index.IndexFileNames;
import conductor.org.apache.lucene.index.SegmentCommitInfo;
import conductor.org.apache.lucene.store.ChecksumIndexInput;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.IOContext;
import conductor.org.apache.lucene.store.IndexOutput;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.FixedBitSet;
import java.io.IOException;
import java.util.Collection;

public final class Lucene50LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        block21: {
            long gen = info.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
            int length = info.info.maxDoc();
            Throwable throwable = null;
            try (ChecksumIndexInput input = dir.openChecksumInput(name, context);){
                Bits bits;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, info.info.getId(), Long.toString(gen, 36));
                    long[] data = new long[FixedBitSet.bits2words(length)];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = input.readLong();
                    }
                    FixedBitSet fbs = new FixedBitSet(data, length);
                    if (fbs.length() - fbs.cardinality() != info.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount(), input);
                    }
                    bits = fbs.asReadOnlyBits();
                }
                catch (Throwable exception) {
                    try {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable2) {
                            CodecUtil.checkFooter(input, priorE);
                            throw throwable2;
                        }
                        CodecUtil.checkFooter(input, priorE);
                        break block21;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
                CodecUtil.checkFooter(input, priorE);
                return bits;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        long gen = info.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
        int delCount = 0;
        try (IndexOutput output = dir.createOutput(name, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info.info.getId(), Long.toString(gen, 36));
            int longCount = FixedBitSet.bits2words(bits.length());
            for (int i = 0; i < longCount; ++i) {
                int j;
                long currentBits = 0L;
                int end = Math.min(j + 63, bits.length() - 1);
                for (j = i << 6; j <= end; ++j) {
                    if (bits.get(j)) {
                        currentBits |= 1L << j;
                        continue;
                    }
                    ++delCount;
                }
                output.writeLong(currentBits);
            }
            CodecUtil.writeFooter(output);
        }
        if (delCount != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + delCount + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name);
        }
    }

    @Override
    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, info.getDelGen()));
        }
    }
}

