/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.snapshots.delete;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.AcknowledgedResponse;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.snapshots.SnapshotsService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;

public class TransportDeleteSnapshotAction
extends TransportMasterNodeAction<DeleteSnapshotRequest, AcknowledgedResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportDeleteSnapshotAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteSnapshotRequest::new);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteSnapshotRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(DeleteSnapshotRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.snapshotsService.deleteSnapshot(request.repository(), request.snapshot(), ActionListener.wrap(v -> listener.onResponse(new AcknowledgedResponse(true)), listener::onFailure), false);
    }
}

