/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.security;

import conductor.org.elasticsearch.client.security.user.User;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GetUsersResponse {
    private final Set<User> users;
    private final Set<User> enabledUsers;
    public static final ParseField USERNAME = new ParseField("username", new String[0]);
    public static final ParseField ROLES = new ParseField("roles", new String[0]);
    public static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
    public static final ParseField EMAIL = new ParseField("email", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ConstructingObjectParser<ParsedUser, String> USER_PARSER = new ConstructingObjectParser("user_info", true, constructorObjects -> {
        int i = 0;
        String username = (String)constructorObjects[i++];
        Collection roles = (Collection)constructorObjects[i++];
        Map metadata = (Map)constructorObjects[i++];
        Boolean enabled = (Boolean)constructorObjects[i++];
        String fullName = (String)constructorObjects[i++];
        String email = (String)constructorObjects[i++];
        return new ParsedUser(username, roles, metadata, enabled, fullName, email);
    });

    public GetUsersResponse(Set<User> users, Set<User> enabledUsers) {
        this.users = Collections.unmodifiableSet(users);
        this.enabledUsers = Collections.unmodifiableSet(enabledUsers);
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public Set<User> getEnabledUsers() {
        return this.enabledUsers;
    }

    public static GetUsersResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        HashSet<User> users = new HashSet<User>();
        HashSet<User> enabledUsers = new HashSet<User>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser::getTokenLocation);
            ParsedUser parsedUser = USER_PARSER.parse(parser, parser.currentName());
            users.add(parsedUser.user);
            if (!parsedUser.enabled) continue;
            enabledUsers.add(parsedUser.user);
        }
        return new GetUsersResponse(users, enabledUsers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUsersResponse)) {
            return false;
        }
        GetUsersResponse that = (GetUsersResponse)o;
        return Objects.equals(this.users, that.users);
    }

    public int hashCode() {
        return Objects.hash(this.users);
    }

    static {
        USER_PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        USER_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES);
        USER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
        USER_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FULL_NAME);
        USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), EMAIL);
    }

    protected static final class ParsedUser {
        protected User user;
        protected boolean enabled;

        public ParsedUser(String username, Collection<String> roles, Map<String, Object> metadata, Boolean enabled, @Nullable String fullName, @Nullable String email) {
            String checkedUsername = username = Objects.requireNonNull(username, "`username` is required, cannot be null");
            Set<String> checkedRoles = Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(roles, "`roles` is required, cannot be null. Pass an empty Collection instead.")));
            Map<String, Object> checkedMetadata = Collections.unmodifiableMap(Objects.requireNonNull(metadata, "`metadata` is required, cannot be null. Pass an empty map instead."));
            this.user = new User(checkedUsername, checkedRoles, checkedMetadata, fullName, email);
            this.enabled = enabled;
        }
    }
}

