/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.settings;

import conductor.joptsimple.OptionSet;
import conductor.org.elasticsearch.cli.EnvironmentAwareCommand;
import conductor.org.elasticsearch.cli.Terminal;
import conductor.org.elasticsearch.cli.UserException;
import conductor.org.elasticsearch.common.settings.KeyStoreWrapper;
import conductor.org.elasticsearch.env.Environment;

public class UpgradeKeyStoreCommand
extends EnvironmentAwareCommand {
    UpgradeKeyStoreCommand() {
        super("Upgrade the keystore format");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper wrapper = KeyStoreWrapper.load(env.configFile());
        if (wrapper == null) {
            throw new UserException(78, "keystore does not exist at [" + KeyStoreWrapper.keystorePath(env.configFile()) + "]");
        }
        wrapper.decrypt(new char[0]);
        KeyStoreWrapper.upgrade(wrapper, env.configFile(), new char[0]);
    }
}

