/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.util;

import conductor.org.elasticsearch.common.CheckedSupplier;
import java.util.Objects;
import java.util.function.Consumer;

public final class LazyInitializable<T, E extends Exception> {
    private final CheckedSupplier<T, E> supplier;
    private final Consumer<T> onGet;
    private final Consumer<T> onReset;
    private volatile T value;

    public LazyInitializable(CheckedSupplier<T, E> supplier) {
        this(supplier, v -> {}, v -> {});
    }

    public LazyInitializable(CheckedSupplier<T, E> supplier, Consumer<T> onGet, Consumer<T> onReset) {
        this.supplier = supplier;
        this.onGet = onGet;
        this.onReset = onReset;
    }

    public T getOrCompute() throws E {
        T readOnce = this.value;
        T result = readOnce == null ? this.maybeCompute(this.supplier) : readOnce;
        this.onGet.accept(result);
        return result;
    }

    public synchronized void reset() {
        if (this.value != null) {
            this.onReset.accept(this.value);
            this.value = null;
        }
    }

    private synchronized T maybeCompute(CheckedSupplier<T, E> supplier) throws E {
        if (this.value == null) {
            this.value = Objects.requireNonNull(supplier.get());
        }
        return this.value;
    }
}

