/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.cache.bitset;

import conductor.org.elasticsearch.common.metrics.CounterMetric;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import conductor.org.elasticsearch.index.shard.ShardId;

public class ShardBitsetFilterCache
extends AbstractIndexShardComponent {
    private final CounterMetric totalMetric = new CounterMetric();

    public ShardBitsetFilterCache(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    public void onRemoval(long sizeInBytes) {
        this.totalMetric.dec(sizeInBytes);
    }

    public long getMemorySizeInBytes() {
        return this.totalMetric.count();
    }
}

