/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.shard;

import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.FilterDirectoryReader;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import conductor.org.elasticsearch.index.engine.Engine;
import java.io.IOException;

public class IndexSearcherWrapper {
    protected DirectoryReader wrap(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected IndexSearcher wrap(IndexSearcher searcher) throws IOException {
        return searcher;
    }

    public final Engine.Searcher wrap(Engine.Searcher engineSearcher) throws IOException {
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(engineSearcher.getDirectoryReader());
        if (elasticsearchDirectoryReader == null) {
            throw new IllegalStateException("Can't wrap non elasticsearch directory reader");
        }
        NonClosingReaderWrapper nonClosingReaderWrapper = new NonClosingReaderWrapper(engineSearcher.getDirectoryReader());
        DirectoryReader reader = this.wrap(nonClosingReaderWrapper);
        if (reader != nonClosingReaderWrapper) {
            if (reader.getReaderCacheHelper() != elasticsearchDirectoryReader.getReaderCacheHelper()) {
                throw new IllegalStateException("wrapped directory reader doesn't delegate IndexReader#getCoreCacheKey, wrappers must override this method and delegate to the original readers core cache key. Wrapped readers can't be used as cache keys since their are used only per request which would lead to subtle bugs");
            }
            if (ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader) != elasticsearchDirectoryReader) {
                throw new IllegalStateException("wrapped directory reader hides actual ElasticsearchDirectoryReader but shouldn't");
            }
        }
        IndexSearcher origIndexSearcher = engineSearcher.searcher();
        IndexSearcher innerIndexSearcher = new IndexSearcher(reader);
        innerIndexSearcher.setQueryCache(origIndexSearcher.getQueryCache());
        innerIndexSearcher.setQueryCachingPolicy(origIndexSearcher.getQueryCachingPolicy());
        innerIndexSearcher.setSimilarity(origIndexSearcher.getSimilarity(true));
        IndexSearcher indexSearcher = this.wrap(innerIndexSearcher);
        if (reader == nonClosingReaderWrapper && indexSearcher == innerIndexSearcher) {
            return engineSearcher;
        }
        return new Engine.Searcher(engineSearcher.source(), indexSearcher, () -> IOUtils.close(indexSearcher.getIndexReader(), engineSearcher));
    }

    private static final class NonClosingReaderWrapper
    extends FilterDirectoryReader {
        private NonClosingReaderWrapper(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                @Override
                public LeafReader wrap(LeafReader reader) {
                    return reader;
                }
            });
        }

        @Override
        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new NonClosingReaderWrapper(in);
        }

        @Override
        protected void doClose() throws IOException {
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

