/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.indices.recovery;

import conductor.org.apache.lucene.store.RateLimiter;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.index.seqno.ReplicationTracker;
import conductor.org.elasticsearch.index.seqno.RetentionLeases;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.index.store.Store;
import conductor.org.elasticsearch.index.store.StoreFileMetaData;
import conductor.org.elasticsearch.index.translog.Translog;
import conductor.org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import conductor.org.elasticsearch.indices.recovery.RecoverySettings;
import conductor.org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import conductor.org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import conductor.org.elasticsearch.indices.recovery.RecoveryTranslogOperationsResponse;
import conductor.org.elasticsearch.indices.recovery.RecoveryWaitForClusterStateRequest;
import conductor.org.elasticsearch.transport.EmptyTransportResponseHandler;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportResponse;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private final TransportService transportService;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final TransportRequestOptions translogOpsRequestOptions;
    private final TransportRequestOptions fileChunkRequestOptions;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final Consumer<Long> onSourceThrottle;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.onSourceThrottle = onSourceThrottle;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
    }

    @Override
    public void prepareForTranslogOperations(boolean fileBasedRecovery, int totalTranslogOps, ActionListener<Void> listener) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/prepare_translog", new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, this.shardId, totalTranslogOps, fileBasedRecovery), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.wrap(r -> listener.onResponse(null), listener::onFailure), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, ActionListener<Void> listener) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/finalize", new RecoveryFinalizeRecoveryRequest(this.recoveryId, this.shardId, globalCheckpoint), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.wrap(r -> listener.onResponse(null), listener::onFailure), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void ensureClusterStateVersion(long clusterStateVersion) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/wait_clusterstate", new RecoveryWaitForClusterStateRequest(this.recoveryId, this.shardId, clusterStateVersion), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, ActionListener<Long> listener) {
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases);
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, new ActionListenerResponseHandler<RecoveryTranslogOperationsResponse>(ActionListener.wrap(r -> listener.onResponse(r.localCheckpoint), listener::onFailure), RecoveryTranslogOperationsResponse::new, "generic"));
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps) {
        RecoveryFilesInfoRequest recoveryInfoFilesRequest = new RecoveryFilesInfoRequest(this.recoveryId, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/filesInfo", recoveryInfoFilesRequest, TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void cleanFiles(int totalTranslogOps, Store.MetadataSnapshot sourceMetaData) throws IOException {
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/clean_files", new RecoveryCleanFilesRequest(this.recoveryId, this.shardId, sourceMetaData, totalTranslogOps), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
    }

    @Override
    public void writeFileChunk(StoreFileMetaData fileMetaData, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        this.transportService.submitRequest(this.targetNode, "internal:index/shard/recovery/file_chunk", new RecoveryFileChunkRequest(this.recoveryId, this.shardId, fileMetaData, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos), this.fileChunkRequestOptions, new ActionListenerResponseHandler<TransportResponse.Empty>(ActionListener.wrap(r -> listener.onResponse(null), listener::onFailure), in -> TransportResponse.Empty.INSTANCE));
    }
}

