/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.ingest;

import conductor.org.elasticsearch.ingest.AbstractProcessor;
import conductor.org.elasticsearch.ingest.ConfigurationUtils;
import conductor.org.elasticsearch.ingest.IngestDocument;
import conductor.org.elasticsearch.ingest.IngestService;
import conductor.org.elasticsearch.ingest.Pipeline;
import conductor.org.elasticsearch.ingest.Processor;
import java.util.Map;

public class PipelineProcessor
extends AbstractProcessor {
    public static final String TYPE = "pipeline";
    private final String pipelineName;
    private final IngestService ingestService;

    private PipelineProcessor(String tag, String pipelineName, IngestService ingestService) {
        super(tag);
        this.pipelineName = pipelineName;
        this.ingestService = ingestService;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Pipeline pipeline = this.ingestService.getPipeline(this.pipelineName);
        if (pipeline == null) {
            throw new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + this.pipelineName + ']');
        }
        return ingestDocument.executePipeline(pipeline);
    }

    Pipeline getPipeline() {
        return this.ingestService.getPipeline(this.pipelineName);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getPipelineName() {
        return this.pipelineName;
    }

    public static final class Factory
    implements Processor.Factory {
        private final IngestService ingestService;

        public Factory(IngestService ingestService) {
            this.ingestService = ingestService;
        }

        @Override
        public PipelineProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String pipeline = ConfigurationUtils.readStringProperty(PipelineProcessor.TYPE, processorTag, config, "name");
            return new PipelineProcessor(processorTag, pipeline, this.ingestService);
        }
    }
}

