/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.join.aggregations;

import conductor.org.apache.lucene.search.Query;
import conductor.org.elasticsearch.join.aggregations.InternalChildren;
import conductor.org.elasticsearch.join.aggregations.ParentToChildrenAggregator;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ChildrenAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.Bytes.WithOrdinals, ChildrenAggregatorFactory> {
    private final Query parentFilter;
    private final Query childFilter;

    public ChildrenAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> config, Query childFilter, Query parentFilter, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.Bytes.WithOrdinals valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        long maxOrd = valuesSource.globalMaxOrd(this.context.searcher());
        if (collectsFromSingleBucket) {
            return new ParentToChildrenAggregator(this.name, this.factories, this.context, parent, this.childFilter, this.parentFilter, valuesSource, maxOrd, pipelineAggregators, metaData);
        }
        return ChildrenAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
    }
}

