/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.plugins;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.bootstrap.JarHell;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PluginInfo
implements Writeable,
ToXContentObject {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private final String name;
    private final String description;
    private final String version;
    private final Version elasticsearchVersion;
    private final String javaVersion;
    private final String classname;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;

    public PluginInfo(String name, String description, String version, Version elasticsearchVersion, String javaVersion, String classname, List<String> extendedPlugins, boolean hasNativeController) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.elasticsearchVersion = elasticsearchVersion;
        this.javaVersion = javaVersion;
        this.classname = classname;
        this.extendedPlugins = Collections.unmodifiableList(extendedPlugins);
        this.hasNativeController = hasNativeController;
    }

    public PluginInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.elasticsearchVersion = Version.readVersion(in);
            this.javaVersion = in.readString();
        } else {
            this.elasticsearchVersion = in.getVersion();
            this.javaVersion = "1.8";
        }
        this.classname = in.readString();
        this.extendedPlugins = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readStringList() : Collections.emptyList();
        this.hasNativeController = in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readBoolean() : false;
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta2) && in.getVersion().before(Version.V_6_3_0)) {
            in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            Version.writeVersion(this.elasticsearchVersion, out);
            out.writeString(this.javaVersion);
        }
        out.writeString(this.classname);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeStringCollection(this.extendedPlugins);
        }
        if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
            out.writeBoolean(this.hasNativeController);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta2) && out.getVersion().before(Version.V_6_3_0)) {
            out.writeBoolean(false);
        }
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        boolean hasNativeController;
        Path descriptor = path.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + descriptor + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String version = propsMap.remove("version");
        if (version == null) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        String esVersionString = propsMap.remove("elasticsearch.version");
        if (esVersionString == null) {
            throw new IllegalArgumentException("property [elasticsearch.version] is missing for plugin [" + name + "]");
        }
        Version esVersion = Version.fromString(esVersionString);
        String javaVersionString = propsMap.remove("java.version");
        if (javaVersionString == null) {
            throw new IllegalArgumentException("property [java.version] is missing for plugin [" + name + "]");
        }
        JarHell.checkVersionFormat(javaVersionString);
        String classname = propsMap.remove("classname");
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        String extendedString = propsMap.remove("extended.plugins");
        List<Object> extendedPlugins = extendedString == null ? Collections.emptyList() : Arrays.asList(Strings.delimitedListToStringArray(extendedString, ","));
        String hasNativeControllerValue = propsMap.remove("has.native.controller");
        if (hasNativeControllerValue == null) {
            hasNativeController = false;
        } else {
            switch (hasNativeControllerValue) {
                case "true": {
                    hasNativeController = true;
                    break;
                }
                case "false": {
                    hasNativeController = false;
                    break;
                }
                default: {
                    String message = String.format(Locale.ROOT, "property [%s] must be [%s], [%s], or unspecified but was [%s]", "has_native_controller", "true", "false", hasNativeControllerValue);
                    throw new IllegalArgumentException(message);
                }
            }
        }
        if (esVersion.before(Version.V_6_3_0) && esVersion.onOrAfter(Version.V_6_0_0_beta2)) {
            propsMap.remove("requires.keystore");
        }
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties in plugin descriptor: " + propsMap.keySet());
        }
        return new PluginInfo(name, description, version, esVersion, javaVersionString, classname, extendedPlugins, hasNativeController);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public String getVersion() {
        return this.version;
    }

    public Version getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("elasticsearch_version", this.elasticsearchVersion);
        builder.field("java_version", this.javaVersion);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("extended_plugins", this.extendedPlugins);
        builder.field("has_native_controller", this.hasNativeController);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder information = new StringBuilder().append(prefix).append("- Plugin information:\n").append(prefix).append("Name: ").append(this.name).append("\n").append(prefix).append("Description: ").append(this.description).append("\n").append(prefix).append("Version: ").append(this.version).append("\n").append(prefix).append("Elasticsearch Version: ").append(this.elasticsearchVersion).append("\n").append(prefix).append("Java Version: ").append(this.javaVersion).append("\n").append(prefix).append("Native Controller: ").append(this.hasNativeController).append("\n").append(prefix).append("Extended Plugins: ").append(this.extendedPlugins).append("\n").append(prefix).append(" * Classname: ").append(this.classname);
        return information.toString();
    }
}

