/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.filter;

import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregationInitializationException;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.internal.ContextIndexSearcher;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FilterAggregatorFactory
extends AggregatorFactory<FilterAggregatorFactory> {
    private Weight weight;
    private Query filter;

    public FilterAggregatorFactory(String name, QueryBuilder filterBuilder, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metaData);
        this.filter = filterBuilder.toFilter(context.getQueryShardContext());
    }

    public Weight getWeight() {
        if (this.weight == null) {
            ContextIndexSearcher contextSearcher = this.context.searcher();
            try {
                this.weight = ((IndexSearcher)contextSearcher).createNormalizedWeight(this.filter, false);
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialse filter", e);
            }
        }
        return this.weight;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new FilterAggregator(this.name, () -> this.getWeight(), this.factories, this.context, parent, pipelineAggregators, metaData);
    }
}

