/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.dfs;

import conductor.com.carrotsearch.hppc.ObjectObjectHashMap;
import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.elasticsearch.common.collect.HppcMaps;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Streamable;
import conductor.org.elasticsearch.search.dfs.DfsSearchResult;
import java.io.IOException;

public class AggregatedDfs
implements Streamable {
    private ObjectObjectHashMap<Term, TermStatistics> termStatistics;
    private ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics;
    private long maxDoc;

    private AggregatedDfs() {
    }

    public AggregatedDfs(ObjectObjectHashMap<Term, TermStatistics> termStatistics, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public ObjectObjectHashMap<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    public static AggregatedDfs readAggregatedDfs(StreamInput in) throws IOException {
        AggregatedDfs result = new AggregatedDfs();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.termStatistics = HppcMaps.newMap(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readBytesRef());
            TermStatistics stats = new TermStatistics(in.readBytesRef(), in.readVLong(), DfsSearchResult.subOne(in.readVLong()));
            this.termStatistics.put(term, stats);
        }
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.termStatistics.size());
        for (ObjectObjectCursor<Term, TermStatistics> objectObjectCursor : this.termStatistics()) {
            Term term = (Term)objectObjectCursor.key;
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
            TermStatistics stats = (TermStatistics)objectObjectCursor.value;
            out.writeBytesRef(stats.term());
            out.writeVLong(stats.docFreq());
            out.writeVLong(DfsSearchResult.addOne(stats.totalTermFreq()));
        }
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }
}

