/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.lookup;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.search.lookup.LeafDocLookup;
import java.util.function.Function;

public class DocLookup {
    private final MapperService mapperService;
    private final Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup;
    @Nullable
    private final String[] types;

    DocLookup(MapperService mapperService, Function<MappedFieldType, IndexFieldData<?>> fieldDataLookup, @Nullable String[] types) {
        this.mapperService = mapperService;
        this.fieldDataLookup = fieldDataLookup;
        this.types = types;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexFieldData<?> getForField(MappedFieldType fieldType) {
        return this.fieldDataLookup.apply(fieldType);
    }

    public LeafDocLookup getLeafDocLookup(LeafReaderContext context) {
        return new LeafDocLookup(this.mapperService, this.fieldDataLookup, this.types, context);
    }

    public String[] getTypes() {
        return this.types;
    }
}

