/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.netty4;

import conductor.io.netty.buffer.ByteBuf;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelDuplexHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.util.Attribute;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.transport.Transports;
import conductor.org.elasticsearch.transport.netty4.Netty4TcpChannel;
import conductor.org.elasticsearch.transport.netty4.Netty4Transport;
import conductor.org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;

    Netty4MessageChannelHandler(Netty4Transport transport) {
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Transports.assertTransportThread();
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + msg.getClass();
        ByteBuf buffer = (ByteBuf)msg;
        try {
            Channel channel = ctx.channel();
            Attribute<Netty4TcpChannel> channelAttribute = channel.attr(Netty4Transport.CHANNEL_KEY);
            this.transport.inboundMessage(channelAttribute.get(), Netty4Utils.toBytesReference(buffer));
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionsHelper.maybeDieOnAnotherThread(cause);
        Throwable unwrapped = ExceptionsHelper.unwrap(cause, ElasticsearchException.class);
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }
}

