/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.elasticsearch;

import com.netflix.conductor.elasticsearch.ElasticSearchConfiguration;
import conductor.org.apache.http.HttpHost;
import conductor.org.apache.http.auth.AuthScope;
import conductor.org.apache.http.auth.UsernamePasswordCredentials;
import conductor.org.apache.http.impl.client.BasicCredentialsProvider;
import conductor.org.elasticsearch.client.RestClient;
import conductor.org.elasticsearch.client.RestClientBuilder;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClientBuilderProvider
implements Provider<RestClientBuilder> {
    private final ElasticSearchConfiguration configuration;
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchRestClientBuilderProvider.class);

    @Inject
    public ElasticSearchRestClientBuilderProvider(ElasticSearchConfiguration configuration) {
        this.configuration = configuration;
    }

    public RestClientBuilder get() {
        RestClientBuilder builder = RestClient.builder(this.convertToHttpHosts(this.configuration.getURIs()));
        if (this.configuration.getElasticSearchBasicAuthUsername() != null && this.configuration.getElasticSearchBasicAuthPassword() != null) {
            logger.info("Configure ElasticSearch with BASIC authentication. User:{}", (Object)this.configuration.getElasticSearchBasicAuthUsername());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.configuration.getElasticSearchBasicAuthUsername(), this.configuration.getElasticSearchBasicAuthPassword()));
            builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider));
        } else {
            logger.info("Configure ElasticSearch with no authentication.");
        }
        return builder;
    }

    private HttpHost[] convertToHttpHosts(List<URI> hosts) {
        List<HttpHost> list = hosts.stream().map(host -> new HttpHost(host.getHost(), host.getPort(), host.getScheme())).collect(Collectors.toList());
        return list.toArray(new HttpHost[list.size()]);
    }
}

