/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.TwoPhaseIterator;
import conductor.org.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.Set;

public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(Query query, float score) {
        super(query);
        this.score = score;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
    }

    protected final float score() {
        return this.score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context);
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match(this.score, this.getQuery().toString() + (this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

