/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.similarities.BasicStats;
import conductor.org.apache.lucene.search.similarities.LMSimilarity;
import java.util.List;
import java.util.Locale;

public class LMJelinekMercerSimilarity
extends LMSimilarity {
    private final float lambda;

    public LMJelinekMercerSimilarity(LMSimilarity.CollectionModel collectionModel, float lambda) {
        super(collectionModel);
        this.lambda = lambda;
    }

    public LMJelinekMercerSimilarity(float lambda) {
        this.lambda = lambda;
    }

    @Override
    protected float score(BasicStats stats, float freq, float docLen) {
        return stats.getBoost() * (float)Math.log(1.0f + (1.0f - this.lambda) * freq / docLen / (this.lambda * ((LMSimilarity.LMStats)stats).getCollectionProbability()));
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, int doc, float freq, float docLen) {
        if (stats.getBoost() != 1.0f) {
            subs.add(Explanation.match(stats.getBoost(), "boost", new Explanation[0]));
        }
        subs.add(Explanation.match(this.lambda, "lambda", new Explanation[0]));
        super.explain(subs, stats, doc, freq, docLen);
    }

    public float getLambda() {
        return this.lambda;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "Jelinek-Mercer(%f)", Float.valueOf(this.getLambda()));
    }
}

