/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.state;

import conductor.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import conductor.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.ClusterStateObserver;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.metadata.IndexMetaData;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.metadata.MetaData;
import conductor.org.elasticsearch.cluster.routing.RoutingTable;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.discovery.zen.PublishClusterStateAction;
import conductor.org.elasticsearch.node.NodeClosedException;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.io.IOException;
import java.util.function.Predicate;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DeprecationLogger deprecationLogger = new DeprecationLogger(this.logger);
    public static final boolean CLUSTER_STATE_SIZE;

    @Inject
    public TransportClusterStateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterStateRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterStateResponse newResponse() {
        return new ClusterStateResponse();
    }

    @Override
    protected void masterOperation(final ClusterStateRequest request, ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        if (request.waitForMetaDataVersion() != null) {
            Predicate<ClusterState> metadataVersionPredicate = clusterState -> clusterState.metaData().version() >= request.waitForMetaDataVersion();
            ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.waitForTimeout(), this.logger, this.threadPool.getThreadContext());
            final ClusterState clusterState2 = observer.setAndGetObservedState();
            if (metadataVersionPredicate.test(clusterState2)) {
                this.buildResponse(request, clusterState2, listener);
            } else {
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        try {
                            TransportClusterStateAction.this.buildResponse(request, state, listener);
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }

                    @Override
                    public void onClusterServiceClose() {
                        listener.onFailure(new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        try {
                            listener.onResponse(new ClusterStateResponse(clusterState2.getClusterName(), null, 0L, true));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }
                }, metadataVersionPredicate);
            }
        } else {
            ClusterState currentState = this.clusterService.state();
            this.buildResponse(request, currentState, listener);
        }
    }

    private void buildResponse(ClusterStateRequest request, ClusterState currentState, ActionListener<ClusterStateResponse> listener) throws IOException {
        long sizeInBytes;
        Object indices;
        this.logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        builder.minimumMasterNodesOnPublishingMaster(currentState.getMinimumMasterNodesOnPublishingMaster());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request);
                for (Object filteredIndex : indices) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey((String)filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get((String)filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        MetaData.Builder mdBuilder = MetaData.builder();
        mdBuilder.clusterUUID(currentState.metaData().clusterUUID());
        if (request.metaData()) {
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metaData().version());
                for (Object filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexMetaData indexMetaData = currentState.metaData().index((String)filteredIndex);
                    if (indexMetaData == null) continue;
                    mdBuilder.put(indexMetaData, false);
                }
            } else {
                mdBuilder = MetaData.builder(currentState.metaData());
            }
            for (ObjectObjectCursor objectObjectCursor : currentState.metaData().customs()) {
                if (((MetaData.Custom)objectObjectCursor.value).context().contains((Object)MetaData.XContentContext.API)) continue;
                mdBuilder.removeCustom((String)objectObjectCursor.key);
            }
        }
        builder.metaData(mdBuilder);
        if (request.customs()) {
            for (ObjectObjectCursor objectObjectCursor : currentState.customs()) {
                if (((ClusterState.Custom)objectObjectCursor.value).isPrivate()) continue;
                builder.putCustom((String)objectObjectCursor.key, (ClusterState.Custom)objectObjectCursor.value);
            }
        }
        if (CLUSTER_STATE_SIZE) {
            this.deprecationLogger.deprecated("es.cluster_state.size is deprecated and will be removed in 7.0.0", new Object[0]);
            sizeInBytes = PublishClusterStateAction.serializeFullClusterState(currentState, Version.CURRENT).length();
        } else {
            sizeInBytes = 0L;
        }
        listener.onResponse(new ClusterStateResponse(currentState.getClusterName(), builder.build(), sizeInBytes, false));
    }

    static {
        String property = System.getProperty("es.cluster_state.size");
        if (property == null) {
            CLUSTER_STATE_SIZE = false;
        } else {
            boolean clusterStateSize = Boolean.parseBoolean(property);
            if (clusterStateSize) {
                CLUSTER_STATE_SIZE = true;
            } else {
                throw new IllegalArgumentException("es.cluster_state.size can only be unset or [true] but was [" + property + "]");
            }
        }
    }
}

