/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indexlifecycle;

import conductor.org.elasticsearch.client.TimedRequest;
import conductor.org.elasticsearch.client.indexlifecycle.LifecyclePolicy;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class PutLifecyclePolicyRequest
extends TimedRequest
implements ToXContentObject {
    private final LifecyclePolicy policy;

    public PutLifecyclePolicyRequest(LifecyclePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy definition cannot be null");
        }
        if (Strings.isNullOrEmpty(policy.getName())) {
            throw new IllegalArgumentException("policy name must be present");
        }
        this.policy = policy;
    }

    public String getName() {
        return this.policy.getName();
    }

    public LifecyclePolicy getLifecyclePolicy() {
        return this.policy;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("policy", this.policy);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutLifecyclePolicyRequest that = (PutLifecyclePolicyRequest)o;
        return Objects.equals(this.getLifecyclePolicy(), that.getLifecyclePolicy());
    }

    public int hashCode() {
        return Objects.hash(this.getLifecyclePolicy());
    }
}

