/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indices;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetFieldMappingsResponse {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ObjectParser<Map<String, FieldMappingMetaData>, String> PARSER = new ObjectParser(MAPPINGS.getPreferredName(), true, HashMap::new);
    private Map<String, Map<String, FieldMappingMetaData>> mappings;

    GetFieldMappingsResponse(Map<String, Map<String, FieldMappingMetaData>> mappings) {
        this.mappings = mappings;
    }

    public Map<String, Map<String, FieldMappingMetaData>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetaData fieldMappings(String index, String field) {
        Map<String, FieldMappingMetaData> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        return indexMapping.get(field);
    }

    public static GetFieldMappingsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        HashMap<String, Map<String, FieldMappingMetaData>> mappings = new HashMap<String, Map<String, FieldMappingMetaData>>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            while (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                String index = parser.currentName();
                Map<String, FieldMappingMetaData> fieldMappings = PARSER.parse(parser, index);
                mappings.put(index, fieldMappings);
                parser.nextToken();
            }
        }
        return new GetFieldMappingsResponse(mappings);
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + this.mappings + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    static {
        PARSER.declareField((p, fieldMappings, index) -> {
            p.nextToken();
            while (p.currentToken() == XContentParser.Token.FIELD_NAME) {
                String fieldName = p.currentName();
                FieldMappingMetaData fieldMappingMetaData = FieldMappingMetaData.fromXContent(p);
                fieldMappings.put(fieldName, fieldMappingMetaData);
                p.nextToken();
            }
        }, MAPPINGS, ObjectParser.ValueType.OBJECT);
    }

    public static class FieldMappingMetaData {
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);
        private static final ConstructingObjectParser<FieldMappingMetaData, String> PARSER = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new FieldMappingMetaData((String)a[0], (BytesReference)a[1]));
        private String fullName;
        private BytesReference source;

        public FieldMappingMetaData(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true, XContentType.JSON).v2();
        }

        BytesReference getSource() {
            return this.source;
        }

        public static FieldMappingMetaData fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        public String toString() {
            return "FieldMappingMetaData{fullName='" + this.fullName + '\'' + ", source=" + this.source + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMappingMetaData)) {
                return false;
            }
            FieldMappingMetaData that = (FieldMappingMetaData)o;
            return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.fullName, this.source);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), FULL_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().copyCurrentStructure(p);
                BytesReference bytes = BytesReference.bytes(jsonBuilder);
                return bytes;
            }, MAPPING, ObjectParser.ValueType.OBJECT);
        }
    }
}

