/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.lucene.uid;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.util.Bits;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import java.io.IOException;

final class PerThreadIDVersionAndSeqNoLookup {
    final String uidField;
    private final TermsEnum termsEnum;
    private PostingsEnum docsEnum;
    private final Object readerKey;

    PerThreadIDVersionAndSeqNoLookup(LeafReader reader, String uidField) throws IOException {
        this.uidField = uidField;
        Terms terms = reader.terms(uidField);
        if (terms == null) {
            NumericDocValues softDeletesDV = reader.getNumericDocValues("__soft_deletes");
            NumericDocValues tombstoneDV = reader.getNumericDocValues("_tombstone");
            if (softDeletesDV == null || tombstoneDV == null) {
                throw new IllegalArgumentException("reader does not have _uid terms but not a no-op segment; _soft_deletes [" + softDeletesDV + "], _tombstone [" + tombstoneDV + "]");
            }
            this.termsEnum = null;
        } else {
            this.termsEnum = terms.iterator();
        }
        if (reader.getNumericDocValues("_version") == null) {
            throw new IllegalArgumentException("reader misses the [_version] field; _uid terms [" + terms + "]");
        }
        IndexReader.CacheKey readerKey = null;
        assert ((readerKey = reader.getCoreCacheHelper().getKey()) != null);
        this.readerKey = readerKey;
    }

    public VersionsAndSeqNoResolver.DocIdAndVersion lookupVersion(BytesRef id, boolean loadSeqNo, LeafReaderContext context) throws IOException {
        assert (context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        int docID = this.getDocID(id, context.reader().getLiveDocs());
        if (docID != Integer.MAX_VALUE) {
            long term;
            long seqNo;
            NumericDocValues versions = context.reader().getNumericDocValues("_version");
            if (versions == null) {
                throw new IllegalArgumentException("reader misses the [_version] field");
            }
            if (!versions.advanceExact(docID)) {
                throw new IllegalArgumentException("Document [" + docID + "] misses the [" + "_version" + "] field");
            }
            if (loadSeqNo) {
                NumericDocValues seqNos = context.reader().getNumericDocValues("_seq_no");
                seqNo = seqNos != null && seqNos.advanceExact(docID) ? seqNos.longValue() : -2L;
                NumericDocValues terms = context.reader().getNumericDocValues("_primary_term");
                term = terms != null && terms.advanceExact(docID) ? terms.longValue() : 0L;
            } else {
                seqNo = -2L;
                term = 0L;
            }
            return new VersionsAndSeqNoResolver.DocIdAndVersion(docID, versions.longValue(), seqNo, term, context.reader(), context.docBase);
        }
        return null;
    }

    private int getDocID(BytesRef id, Bits liveDocs) throws IOException {
        if (this.termsEnum != null && this.termsEnum.seekExact(id)) {
            int docID = Integer.MAX_VALUE;
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            int d = this.docsEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    docID = d;
                }
                d = this.docsEnum.nextDoc();
            }
            return docID;
        }
        return Integer.MAX_VALUE;
    }

    VersionsAndSeqNoResolver.DocIdAndSeqNo lookupSeqNo(BytesRef id, LeafReaderContext context) throws IOException {
        assert (context.reader().getCoreCacheHelper().getKey().equals(this.readerKey)) : "context's reader is not the same as the reader class was initialized on.";
        if (this.termsEnum != null && this.termsEnum.seekExact(id)) {
            this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
            Bits liveDocs = context.reader().getLiveDocs();
            VersionsAndSeqNoResolver.DocIdAndSeqNo result = null;
            int docID = this.docsEnum.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                NumericDocValues seqNoDV = context.reader().getNumericDocValues("_seq_no");
                while (docID != Integer.MAX_VALUE) {
                    boolean isLive;
                    long seqNo = seqNoDV != null && seqNoDV.advanceExact(docID) ? seqNoDV.longValue() : -2L;
                    boolean bl = isLive = liveDocs == null || liveDocs.get(docID);
                    if (isLive) {
                        assert (result == null || result.seqNo <= seqNo) : "the live doc does not have the highest seq_no; live_seq_no=" + seqNo + " < deleted_seq_no=" + result.seqNo;
                        return new VersionsAndSeqNoResolver.DocIdAndSeqNo(docID, seqNo, context, isLive);
                    }
                    if (result == null || result.seqNo < seqNo) {
                        result = new VersionsAndSeqNoResolver.DocIdAndSeqNo(docID, seqNo, context, isLive);
                    }
                    docID = this.docsEnum.nextDoc();
                }
            }
            return result;
        }
        return null;
    }
}

