/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.search;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.CachingTokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import conductor.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import conductor.org.apache.lucene.index.IndexOptions;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.queries.ExtendedCommonTermsQuery;
import conductor.org.apache.lucene.search.BooleanClause;
import conductor.org.apache.lucene.search.BooleanQuery;
import conductor.org.apache.lucene.search.FuzzyQuery;
import conductor.org.apache.lucene.search.MultiTermQuery;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import conductor.org.apache.lucene.search.spans.SpanNearQuery;
import conductor.org.apache.lucene.search.spans.SpanOrQuery;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanTermQuery;
import conductor.org.apache.lucene.util.QueryBuilder;
import conductor.org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.io.stream.Writeable;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.common.lucene.search.Queries;
import conductor.org.elasticsearch.common.lucene.search.SpanBooleanQueryRewriteWithMaxClause;
import conductor.org.elasticsearch.common.unit.Fuzziness;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.support.QueryParsers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;

public class MatchQuery {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(MappedFieldType.class));
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final boolean DEFAULT_LENIENCY = false;
    public static final ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQuery.NONE;
    protected final QueryShardContext context;
    protected Analyzer analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected SpanMultiTermQueryWrapper.SpanRewriteMethod spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause(50, false);
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient = false;
    protected ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    protected Float commonTermsCutoff = null;
    protected boolean autoGenerateSynonymsPhraseQuery = true;

    public MatchQuery(QueryShardContext context) {
        this.context = context;
    }

    public void setAnalyzer(String analyzerName) {
        this.analyzer = this.context.getMapperService().getIndexAnalyzers().get(analyzerName);
        if (this.analyzer == null) {
            throw new IllegalArgumentException("No analyzer found for [" + analyzerName + "]");
        }
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(Float cutoff) {
        this.commonTermsCutoff = cutoff;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        this.spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause(maxExpansions, false);
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    public void setAutoGenerateSynonymsPhraseQuery(boolean enabled) {
        this.autoGenerateSynonymsPhraseQuery = enabled;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        MappedFieldType fieldType = this.context.fieldMapper(fieldName);
        if (fieldType == null) {
            return Queries.newUnmappedFieldQuery(fieldName);
        }
        Analyzer analyzer = this.getAnalyzer(fieldType, type == Type.PHRASE || type == Type.PHRASE_PREFIX);
        assert (analyzer != null);
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, fieldType);
        if (analyzer == Lucene.KEYWORD_ANALYZER && type != Type.PHRASE_PREFIX) {
            return builder.newTermQuery(new Term(fieldName, value.toString()));
        }
        return this.parseInternal(type, fieldName, builder, value);
    }

    protected final Query parseInternal(Type type, String fieldName, MatchQueryBuilder builder, Object value) throws IOException {
        Query query;
        switch (type) {
            case BOOLEAN: {
                if (this.commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(fieldName, value.toString(), this.occur);
                    break;
                }
                query = this.createCommonTermsQuery(builder, fieldName, value.toString(), this.occur, this.occur, this.commonTermsCutoff.floatValue());
                break;
            }
            case PHRASE: {
                query = builder.createPhraseQuery(fieldName, value.toString(), this.phraseSlop);
                break;
            }
            case PHRASE_PREFIX: {
                query = builder.createPhrasePrefixQuery(fieldName, value.toString(), this.phraseSlop);
                break;
            }
            default: {
                throw new IllegalStateException("No type found for [" + type + "]");
            }
        }
        return query == null ? this.zeroTermsQuery() : query;
    }

    private Query createCommonTermsQuery(MatchQueryBuilder builder, String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
        Query booleanQuery = builder.createBooleanQuery(field, queryText, lowFreqOccur);
        if (booleanQuery != null && booleanQuery instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)booleanQuery;
            return this.boolToExtendedCommonTermsQuery(bq, highFreqOccur, lowFreqOccur, maxTermFrequency);
        }
        return booleanQuery;
    }

    private Query boolToExtendedCommonTermsQuery(BooleanQuery bq, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
        ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency);
        for (BooleanClause clause : bq.clauses()) {
            if (!(clause.getQuery() instanceof TermQuery)) {
                return bq;
            }
            query.add(((TermQuery)clause.getQuery()).getTerm());
        }
        return query;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType, boolean quoted) {
        if (this.analyzer == null) {
            return quoted ? this.context.getSearchQuoteAnalyzer(fieldType) : this.context.getSearchAnalyzer(fieldType);
        }
        return this.analyzer;
    }

    protected Query zeroTermsQuery() {
        switch (this.zeroTermsQuery) {
            case NULL: {
                return null;
            }
            case NONE: {
                return Queries.newMatchNoDocsQuery("Matching no documents because no terms present");
            }
            case ALL: {
                return Queries.newMatchAllQuery();
            }
        }
        throw new IllegalStateException("unknown zeroTermsQuery " + this.zeroTermsQuery);
    }

    private boolean hasPositions(MappedFieldType fieldType) {
        return fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    class MatchQueryBuilder
    extends QueryBuilder {
        private final MappedFieldType fieldType;

        MatchQueryBuilder(Analyzer analyzer, MappedFieldType fieldType) {
            super(analyzer);
            this.fieldType = fieldType;
            if (MatchQuery.this.hasPositions(fieldType)) {
                this.setAutoGenerateMultiTermSynonymsPhraseQuery(MatchQuery.this.autoGenerateSynonymsPhraseQuery);
            } else {
                this.setAutoGenerateMultiTermSynonymsPhraseQuery(false);
            }
            this.setEnablePositionIncrements(this.enablePositionIncrements);
        }

        @Override
        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int slop) {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            Type type = quoted ? Type.PHRASE : Type.BOOLEAN;
            return this.createQuery(field, queryText, type, operator, slop);
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int slop) {
            return this.createQuery(field, queryText, Type.PHRASE_PREFIX, MatchQuery.this.occur, slop);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Query createFieldQuery(TokenStream source, Type type, BooleanClause.Occur operator, String field, int phraseSlop) {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            try (CachingTokenFilter stream = new CachingTokenFilter(source);){
                TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
                PositionIncrementAttribute posIncAtt = stream.addAttribute(PositionIncrementAttribute.class);
                PositionLengthAttribute posLenAtt = stream.addAttribute(PositionLengthAttribute.class);
                if (termAtt == null) {
                    Query query = null;
                    return query;
                }
                int numTokens = 0;
                int positionCount = 0;
                boolean hasSynonyms = false;
                boolean isGraph = false;
                stream.reset();
                while (stream.incrementToken()) {
                    ++numTokens;
                    int positionIncrement = posIncAtt.getPositionIncrement();
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        hasSynonyms = true;
                    }
                    int positionLength = posLenAtt.getPositionLength();
                    if (!this.enableGraphQueries || positionLength <= 1) continue;
                    isGraph = true;
                }
                if (numTokens == 0) {
                    Query query = null;
                    return query;
                }
                if (numTokens == 1) {
                    if (type == Type.PHRASE_PREFIX) {
                        Query query = this.analyzePhrasePrefix(field, stream, phraseSlop, positionCount);
                        return query;
                    }
                    Query query = this.analyzeTerm(field, stream);
                    return query;
                }
                if (isGraph) {
                    if (type != Type.PHRASE && type != Type.PHRASE_PREFIX) {
                        Query query = this.analyzeGraphBoolean(field, stream, operator);
                        return query;
                    }
                    Query query = this.analyzeGraphPhrase(stream, field, type, phraseSlop);
                    return query;
                }
                if (type == Type.PHRASE && positionCount > 1) {
                    if (hasSynonyms) {
                        Query query = this.analyzeMultiPhrase(field, stream, phraseSlop);
                        return query;
                    }
                    Query query = this.analyzePhrase(field, stream, phraseSlop);
                    return query;
                }
                if (type == Type.PHRASE_PREFIX) {
                    Query query = this.analyzePhrasePrefix(field, stream, phraseSlop, positionCount);
                    return query;
                }
                if (positionCount == 1) {
                    Query query = this.analyzeBoolean(field, stream);
                    return query;
                }
                Query query = this.analyzeMultiBoolean(field, stream, operator);
                return query;
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private Query createQuery(String field, String queryText, Type type, BooleanClause.Occur operator, int phraseSlop) {
            try (TokenStream source = this.analyzer.tokenStream(field, queryText);){
                Query query;
                if (source.hasAttribute(DisableGraphAttribute.class)) {
                    this.setEnableGraphQueries(false);
                }
                try {
                    query = this.createFieldQuery(source, type, operator, field, phraseSlop);
                }
                catch (Throwable throwable) {
                    this.setEnableGraphQueries(true);
                    throw throwable;
                }
                this.setEnableGraphQueries(true);
                return query;
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }

        private SpanQuery newSpanQuery(Term[] terms, boolean prefix) {
            if (terms.length == 1) {
                return prefix ? this.fieldType.spanPrefixQuery(terms[0].text(), MatchQuery.this.spanRewriteMethod, MatchQuery.this.context) : new SpanTermQuery(terms[0]);
            }
            SpanQuery[] spanQueries = new SpanQuery[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                spanQueries[i] = prefix ? this.fieldType.spanPrefixQuery(terms[i].text(), MatchQuery.this.spanRewriteMethod, MatchQuery.this.context) : new SpanTermQuery(terms[i]);
            }
            return new SpanOrQuery(spanQueries);
        }

        @Override
        protected SpanQuery createSpanQuery(TokenStream in, String field) throws IOException {
            return this.createSpanQuery(in, field, false);
        }

        private SpanQuery createSpanQuery(TokenStream in, String field, boolean prefix) throws IOException {
            SpanNearQuery query;
            SpanQuery[] clauses;
            TermToBytesRefAttribute termAtt = in.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncAtt = in.getAttribute(PositionIncrementAttribute.class);
            if (termAtt == null) {
                return null;
            }
            SpanNearQuery.Builder builder = new SpanNearQuery.Builder(field, true);
            Term lastTerm = null;
            while (in.incrementToken()) {
                if (posIncAtt.getPositionIncrement() > 1) {
                    builder.addGap(posIncAtt.getPositionIncrement() - 1);
                }
                if (lastTerm != null) {
                    builder.addClause(new SpanTermQuery(lastTerm));
                }
                lastTerm = new Term(field, termAtt.getBytesRef());
            }
            if (lastTerm != null) {
                SpanTermQuery spanQuery = prefix ? this.fieldType.spanPrefixQuery(lastTerm.text(), MatchQuery.this.spanRewriteMethod, MatchQuery.this.context) : new SpanTermQuery(lastTerm);
                builder.addClause(spanQuery);
            }
            if ((clauses = (query = builder.build()).getClauses()).length == 1) {
                return clauses[0];
            }
            return query;
        }

        @Override
        protected Query newTermQuery(Term term) {
            Supplier<Query> querySupplier = MatchQuery.this.fuzziness != null ? () -> {
                Query query = this.fieldType.fuzzyQuery(term.text(), MatchQuery.this.fuzziness, MatchQuery.this.fuzzyPrefixLength, MatchQuery.this.maxExpansions, MatchQuery.this.transpositions);
                if (query instanceof FuzzyQuery) {
                    QueryParsers.setRewriteMethod((FuzzyQuery)query, MatchQuery.this.fuzzyRewriteMethod);
                }
                return query;
            } : () -> this.fieldType.termQuery(term.bytes(), MatchQuery.this.context);
            try {
                Query query = querySupplier.get();
                return query;
            }
            catch (RuntimeException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(this.fieldType.name(), e);
                }
                throw e;
            }
        }

        @Override
        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                return this.fieldType.phraseQuery(stream, slop, this.enablePositionIncrements);
            }
            catch (IllegalStateException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!MatchQuery.this.lenient) {
                    DEPRECATION_LOGGER.deprecated(e.getMessage(), new Object[0]);
                }
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        @Override
        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                this.checkForPositions(field);
                return this.fieldType.multiPhraseQuery(stream, slop, this.enablePositionIncrements);
            }
            catch (IllegalStateException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!MatchQuery.this.lenient) {
                    DEPRECATION_LOGGER.deprecated(e.getMessage(), new Object[0]);
                }
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        private Query analyzePhrasePrefix(String field, TokenStream stream, int slop, int positionCount) throws IOException {
            try {
                if (positionCount > 1) {
                    this.checkForPositions(field);
                }
                return this.fieldType.phrasePrefixQuery(stream, slop, MatchQuery.this.maxExpansions);
            }
            catch (IllegalStateException e) {
                if (MatchQuery.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (!MatchQuery.this.lenient) {
                    DEPRECATION_LOGGER.deprecated(e.getMessage(), new Object[0]);
                }
                return Queries.newLenientFieldQuery(field, e);
            }
        }

        private Query analyzeGraphPhrase(TokenStream source, String field, Type type, int slop) throws IOException {
            assert (type == Type.PHRASE_PREFIX || type == Type.PHRASE);
            source.reset();
            GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
            if (MatchQuery.this.phraseSlop > 0) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                Iterator<TokenStream> it = graph.getFiniteStrings();
                while (it.hasNext()) {
                    Query query = this.createFieldQuery(it.next(), type, BooleanClause.Occur.MUST, field, slop);
                    if (query == null) continue;
                    builder.add(query, BooleanClause.Occur.SHOULD);
                }
                return builder.build();
            }
            ArrayList<SpanQuery> clauses = new ArrayList<SpanQuery>();
            int[] articulationPoints = graph.articulationPoints();
            int lastState = 0;
            int maxClauseCount = BooleanQuery.getMaxClauseCount();
            for (int i = 0; i <= articulationPoints.length; ++i) {
                SpanQuery queryPos;
                boolean endPrefix;
                int start = lastState;
                int end = -1;
                if (i < articulationPoints.length) {
                    end = articulationPoints[i];
                }
                lastState = end;
                boolean bl = endPrefix = end == -1 && type == Type.PHRASE_PREFIX;
                if (graph.hasSidePath(start)) {
                    ArrayList<SpanQuery> queries = new ArrayList<SpanQuery>();
                    Iterator<TokenStream> it = graph.getFiniteStrings(start, end);
                    while (it.hasNext()) {
                        TokenStream ts = it.next();
                        SpanQuery q = this.createSpanQuery(ts, field, endPrefix);
                        if (q == null) continue;
                        if (queries.size() >= maxClauseCount) {
                            throw new BooleanQuery.TooManyClauses();
                        }
                        queries.add(q);
                    }
                    queryPos = queries.size() > 0 ? new SpanOrQuery(queries.toArray(new SpanQuery[0])) : null;
                } else {
                    Term[] terms = graph.getTerms(field, start);
                    assert (terms.length > 0);
                    if (terms.length >= maxClauseCount) {
                        throw new BooleanQuery.TooManyClauses();
                    }
                    queryPos = this.newSpanQuery(terms, endPrefix);
                }
                if (queryPos == null) continue;
                if (clauses.size() >= maxClauseCount) {
                    throw new BooleanQuery.TooManyClauses();
                }
                clauses.add(queryPos);
            }
            if (clauses.isEmpty()) {
                return null;
            }
            if (clauses.size() == 1) {
                return (Query)clauses.get(0);
            }
            return new SpanNearQuery(clauses.toArray(new SpanQuery[0]), 0, true);
        }

        private void checkForPositions(String field) {
            if (!MatchQuery.this.hasPositions(this.fieldType)) {
                throw new IllegalStateException("field:[" + field + "] was indexed without position data; cannot run PhraseQuery");
            }
        }
    }

    public static enum ZeroTermsQuery implements Writeable
    {
        NONE(0),
        ALL(1),
        NULL(2);

        private final int ordinal;

        private ZeroTermsQuery(int ordinal) {
            this.ordinal = ordinal;
        }

        public static ZeroTermsQuery readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (ZeroTermsQuery zeroTermsQuery : ZeroTermsQuery.values()) {
                if (zeroTermsQuery.ordinal != ord) continue;
                return zeroTermsQuery;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }

    public static enum Type implements Writeable
    {
        BOOLEAN(0),
        PHRASE(1),
        PHRASE_PREFIX(2);

        private final int ordinal;

        private Type(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (Type type : Type.values()) {
                if (type.ordinal != ord) continue;
                return type;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }
}

