/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.fs;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.apache.lucene.util.Constants;
import conductor.org.elasticsearch.cluster.ClusterInfo;
import conductor.org.elasticsearch.cluster.DiskUsage;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.io.PathUtils;
import conductor.org.elasticsearch.env.NodeEnvironment;
import conductor.org.elasticsearch.monitor.fs.FsInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FsProbe {
    private static final Logger logger = LogManager.getLogger(FsProbe.class);
    private final NodeEnvironment nodeEnv;

    public FsProbe(NodeEnvironment nodeEnv) {
        this.nodeEnv = nodeEnv;
    }

    public FsInfo stats(FsInfo previous, @Nullable ClusterInfo clusterInfo) throws IOException {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsInfo(System.currentTimeMillis(), null, new FsInfo.Path[0]);
        }
        NodeEnvironment.NodePath[] dataLocations = this.nodeEnv.nodePaths();
        FsInfo.Path[] paths = new FsInfo.Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            paths[i] = FsProbe.getFSInfo(dataLocations[i]);
        }
        FsInfo.IoStats ioStats = null;
        if (Constants.LINUX) {
            HashSet<Tuple<Integer, Integer>> devicesNumbers = new HashSet<Tuple<Integer, Integer>>();
            for (int i = 0; i < dataLocations.length; ++i) {
                if (dataLocations[i].majorDeviceNumber == -1 || dataLocations[i].minorDeviceNumber == -1) continue;
                devicesNumbers.add(Tuple.tuple(dataLocations[i].majorDeviceNumber, dataLocations[i].minorDeviceNumber));
            }
            ioStats = this.ioStats(devicesNumbers, previous);
        }
        DiskUsage leastDiskEstimate = null;
        DiskUsage mostDiskEstimate = null;
        if (clusterInfo != null) {
            leastDiskEstimate = clusterInfo.getNodeLeastAvailableDiskUsages().get(this.nodeEnv.nodeId());
            mostDiskEstimate = clusterInfo.getNodeMostAvailableDiskUsages().get(this.nodeEnv.nodeId());
        }
        return new FsInfo(System.currentTimeMillis(), ioStats, paths, leastDiskEstimate, mostDiskEstimate);
    }

    final FsInfo.IoStats ioStats(Set<Tuple<Integer, Integer>> devicesNumbers, FsInfo previous) {
        try {
            HashMap<Tuple<Integer, Integer>, FsInfo.DeviceStats> deviceMap = new HashMap<Tuple<Integer, Integer>, FsInfo.DeviceStats>();
            if (previous != null && previous.getIoStats() != null && previous.getIoStats().devicesStats != null) {
                for (int i = 0; i < previous.getIoStats().devicesStats.length; ++i) {
                    FsInfo.DeviceStats deviceStats = previous.getIoStats().devicesStats[i];
                    deviceMap.put(Tuple.tuple(deviceStats.majorDeviceNumber, deviceStats.minorDeviceNumber), deviceStats);
                }
            }
            ArrayList<FsInfo.DeviceStats> devicesStats = new ArrayList<FsInfo.DeviceStats>();
            List<String> lines = this.readProcDiskStats();
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields = line.trim().split("\\s+");
                    int majorDeviceNumber = Integer.parseInt(fields[0]);
                    int minorDeviceNumber = Integer.parseInt(fields[1]);
                    if (!devicesNumbers.contains(Tuple.tuple(majorDeviceNumber, minorDeviceNumber))) continue;
                    String deviceName = fields[2];
                    long readsCompleted = Long.parseLong(fields[3]);
                    long sectorsRead = Long.parseLong(fields[5]);
                    long writesCompleted = Long.parseLong(fields[7]);
                    long sectorsWritten = Long.parseLong(fields[9]);
                    FsInfo.DeviceStats deviceStats = new FsInfo.DeviceStats(majorDeviceNumber, minorDeviceNumber, deviceName, readsCompleted, sectorsRead, writesCompleted, sectorsWritten, (FsInfo.DeviceStats)deviceMap.get(Tuple.tuple(majorDeviceNumber, minorDeviceNumber)));
                    devicesStats.add(deviceStats);
                }
            }
            return new FsInfo.IoStats(devicesStats.toArray(new FsInfo.DeviceStats[devicesStats.size()]));
        }
        catch (Exception e) {
            logger.debug(() -> new ParameterizedMessage("unexpected exception processing /proc/diskstats for devices {}", (Object)devicesNumbers), (Throwable)e);
            return null;
        }
    }

    @SuppressForbidden(reason="read /proc/diskstats")
    List<String> readProcDiskStats() throws IOException {
        return Files.readAllLines(PathUtils.get("/proc/diskstats", new String[0]));
    }

    static long adjustForHugeFilesystems(long bytes) {
        if (bytes < 0L) {
            return Long.MAX_VALUE;
        }
        return bytes;
    }

    public static FsInfo.Path getFSInfo(NodeEnvironment.NodePath nodePath) throws IOException {
        FsInfo.Path fsPath = new FsInfo.Path();
        fsPath.path = nodePath.path.toString();
        fsPath.total = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getTotalSpace());
        fsPath.free = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getUnallocatedSpace());
        fsPath.available = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getUsableSpace());
        fsPath.type = nodePath.fileStore.type();
        fsPath.mount = nodePath.fileStore.toString();
        return fsPath;
    }
}

