/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.monitor.os;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.unit.TimeValue;
import conductor.org.elasticsearch.common.util.SingleObjectCache;
import conductor.org.elasticsearch.common.util.concurrent.EsExecutors;
import conductor.org.elasticsearch.monitor.os.OsInfo;
import conductor.org.elasticsearch.monitor.os.OsProbe;
import conductor.org.elasticsearch.monitor.os.OsStats;
import java.io.IOException;

public class OsService {
    private static final Logger logger = LogManager.getLogger(OsService.class);
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public OsService(Settings settings) throws IOException {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), EsExecutors.numberOfProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval, this.probe.osStats());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }
}

