/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.percolator;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.IndexReaderContext;
import conductor.org.apache.lucene.index.IndexWriter;
import conductor.org.apache.lucene.index.IndexWriterConfig;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.apache.lucene.index.memory.MemoryIndex;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.join.BitSetProducer;
import conductor.org.apache.lucene.store.RAMDirectory;
import conductor.org.apache.lucene.util.BitDocIdSet;
import conductor.org.apache.lucene.util.BitSet;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.SetOnce;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ResourceNotFoundException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.get.GetRequest;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.ParsingException;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.InputStreamStreamInput;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentHelper;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.index.analysis.FieldNameAnalyzer;
import conductor.org.elasticsearch.index.fielddata.IndexFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.mapper.DocumentMapper;
import conductor.org.elasticsearch.index.mapper.DocumentMapperForType;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.ParsedDocument;
import conductor.org.elasticsearch.index.mapper.SourceToParse;
import conductor.org.elasticsearch.index.query.AbstractQueryBuilder;
import conductor.org.elasticsearch.index.query.QueryBuilder;
import conductor.org.elasticsearch.index.query.QueryRewriteContext;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.index.query.QueryShardException;
import conductor.org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import conductor.org.elasticsearch.percolator.PercolateQuery;
import conductor.org.elasticsearch.percolator.PercolatorFieldMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    public static final String NAME = "percolate";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ParseField.class));
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    static final ParseField DOCUMENTS_FIELD = new ParseField("documents", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private String name;
    @Deprecated
    private final String documentType;
    private final List<BytesReference> documents;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentType;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document) {
        this(field, documentType, Collections.singletonList(document), XContentHelper.xContentType(document));
    }

    public PercolateQueryBuilder(String field, BytesReference document, XContentType documentXContentType) {
        this(field, null, Collections.singletonList(document), documentXContentType);
    }

    public PercolateQueryBuilder(String field, List<BytesReference> documents, XContentType documentXContentType) {
        this(field, null, documents, documentXContentType);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, List<BytesReference> documents, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documents == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = documents;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    protected PercolateQueryBuilder(String field, String documentType, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    public PercolateQueryBuilder(String field, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        this(field, null, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentType == null) {
            throw new IllegalArgumentException("[type] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentType = indexedDocumentType;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.name = in.readOptionalString();
        }
        this.documentType = in.getVersion().before(Version.V_6_0_0_beta1) ? in.readString() : in.readOptionalString();
        this.indexedDocumentIndex = in.readOptionalString();
        this.indexedDocumentType = in.readOptionalString();
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.documents = in.readList(StreamInput::readBytesReference);
        } else {
            BytesReference document = in.readOptionalBytesReference();
            List<Object> list = this.documents = document != null ? Collections.singletonList(document) : Collections.emptyList();
        }
        this.documentXContentType = !this.documents.isEmpty() ? (in.getVersion().onOrAfter(Version.V_5_3_0) ? in.readEnum(XContentType.class) : XContentHelper.xContentType(this.documents.iterator().next())) : null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalString(this.name);
        }
        if (out.getVersion().before(Version.V_6_0_0_beta1)) {
            out.writeString(this.documentType);
        } else {
            out.writeOptionalString(this.documentType);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        out.writeOptionalString(this.indexedDocumentType);
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeVInt(this.documents.size());
            for (BytesReference document : this.documents) {
                out.writeBytesReference(document);
            }
        } else {
            if (this.documents.size() > 1) {
                throw new IllegalArgumentException("Nodes prior to 6.1.0 cannot accept multiple documents");
            }
            BytesReference doc = this.documents.isEmpty() ? null : this.documents.iterator().next();
            out.writeOptionalBytesReference(doc);
        }
        if (!this.documents.isEmpty() && out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum(this.documentXContentType);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(DOCUMENT_TYPE_FIELD.getPreferredName(), this.documentType);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (!this.documents.isEmpty()) {
            builder.startArray(DOCUMENTS_FIELD.getPreferredName());
            for (BytesReference document : this.documents) {
                XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, document);
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            builder.endArray();
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentType != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), this.indexedDocumentType);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static PercolateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        PercolateQueryBuilder queryBuilder;
        XContentParser.Token token;
        float boost = 1.0f;
        String field = null;
        String name = null;
        String documentType = null;
        String indexedDocumentIndex = null;
        String indexedDocumentType = null;
        String indexedDocumentId = null;
        String indexedDocumentRouting = null;
        String indexedDocumentPreference = null;
        Long indexedDocumentVersion = null;
        ArrayList<BytesReference> documents = new ArrayList<BytesReference>();
        String queryName = null;
        String currentFieldName = null;
        boolean documentsSpecified = false;
        boolean documentSpecified = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentBuilder builder;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (DOCUMENTS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (documentSpecified) {
                        throw new IllegalArgumentException("[percolate] Either specified [document] or [documents], not both");
                    }
                    documentsSpecified = true;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            builder = XContentFactory.jsonBuilder();
                            try {
                                builder.copyCurrentStructure(parser);
                                builder.flush();
                                documents.add(BytesReference.bytes(builder));
                                continue;
                            }
                            finally {
                                if (builder != null) {
                                    builder.close();
                                }
                                continue;
                            }
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + (Object)((Object)token) + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not field name [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (DOCUMENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (documentsSpecified) {
                        throw new IllegalArgumentException("[percolate] Either specified [document] or [documents], not both");
                    }
                    documentSpecified = true;
                    builder = XContentFactory.jsonBuilder();
                    try {
                        builder.copyCurrentStructure(parser);
                        builder.flush();
                        documents.add(BytesReference.bytes(builder));
                        continue;
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                        continue;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support field name [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue() || token == XContentParser.Token.VALUE_NULL) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    field = parser.text();
                    continue;
                }
                if (NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    name = parser.textOrNull();
                    continue;
                }
                if (DOCUMENT_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    documentType = parser.textOrNull();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentIndex = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentType = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentId = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentRouting = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_PREFERENCE.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentPreference = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexedDocumentVersion = parser.longValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + (Object)((Object)token) + "]", new Object[0]);
        }
        if (!documents.isEmpty()) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, documents, XContentType.JSON);
        } else if (indexedDocumentId != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
        } else {
            throw new IllegalArgumentException("[percolate] query, nothing to percolate");
        }
        if (name != null) {
            queryBuilder.setName(name);
        }
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        return queryBuilder;
    }

    @Override
    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.documents, other.documents) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.indexedDocumentType, other.indexedDocumentType) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, this.documentType, this.documents, this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId, this.documentSupplier);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) {
        if (!this.documents.isEmpty()) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, this.documentType, Collections.singletonList(source), XContentHelper.xContentType(source));
            if (this.name != null) {
                rewritten.setName(this.name);
            }
            return rewritten;
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion);
        }
        SetOnce documentSupplier = new SetOnce();
        queryShardContext.registerAsyncAction((client, listener) -> client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}/{}/{}] couldn't be found", this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
            }
            if (getResponse.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentType + "/" + this.indexedDocumentId + "] source disabled");
            }
            documentSupplier.set(getResponse.getSourceAsBytesRef());
            listener.onResponse(null);
        }, listener::onFailure)));
        PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, this.documentType, documentSupplier::get);
        if (this.name != null) {
            rewritten.setName(this.name);
        }
        return rewritten;
    }

    @Override
    protected Query doToQuery(final QueryShardContext context) throws IOException {
        boolean excludeNestedDocuments;
        IndexSearcher docSearcher;
        DocumentMapper docMapper;
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null || this.documentSupplier != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.documents.isEmpty()) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.FieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        ArrayList<ParsedDocument> docs = new ArrayList<ParsedDocument>();
        MapperService mapperService = context.getMapperService();
        if (context.getIndexSettings().isSingleType()) {
            Collection<String> types = mapperService.types();
            if (types.size() != 1) {
                throw new IllegalStateException("Only a single type should exist, but [" + types.size() + " types exists");
            }
            String type = types.iterator().next();
            if (this.documentType != null) {
                DEPRECATION_LOGGER.deprecated("[document_type] parameter has been deprecated because types have been deprecated", new Object[0]);
                if (!this.documentType.equals(type)) {
                    throw new IllegalArgumentException("specified document_type [" + this.documentType + "] is not equal to the actual type [" + (String)type + "]");
                }
            }
            docMapper = mapperService.documentMapper(type);
            for (BytesReference document : this.documents) {
                docs.add(docMapper.parse(SourceToParse.source(context.index().getName(), type, "_temp_id", document, this.documentXContentType)));
            }
        } else {
            if (this.documentType == null) {
                throw new IllegalArgumentException("[percolate] query is missing required [document_type] parameter");
            }
            DocumentMapperForType docMapperForType = mapperService.documentMapperWithAutoCreate(this.documentType);
            docMapper = docMapperForType.getDocumentMapper();
            for (BytesReference document : this.documents) {
                docs.add(docMapper.parse(SourceToParse.source(context.index().getName(), this.documentType, "_temp_id", document, this.documentXContentType)));
            }
        }
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (docs.size() > 1 || ((ParsedDocument)docs.get(0)).docs().size() > 1) {
            assert (docs.size() != 1 || docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher(analyzer, docs);
            excludeNestedDocuments = docMapper.hasNestedObjects() && docs.stream().map(ParsedDocument::docs).mapToInt(List::size).anyMatch(size -> size > 1);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument(((ParsedDocument)docs.get(0)).rootDoc(), analyzer, true, false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
            excludeNestedDocuments = false;
        }
        PercolatorFieldMapper.FieldType pft = (PercolatorFieldMapper.FieldType)fieldType;
        String name = this.name != null ? this.name : pft.name();
        QueryShardContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft.queryBuilderField, percolateShardContext, pft.mapUnmappedFieldsAsText);
        return pft.percolateQuery(name, queryStore, this.documents, docSearcher, excludeNestedDocuments, context.indexVersionCreated());
    }

    public String getField() {
        return this.field;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public List<BytesReference> getDocuments() {
        return this.documents;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    public String getQueryName() {
        return this.name;
    }

    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, Collection<ParsedDocument> docs) {
        IndexSearcher indexSearcher;
        RAMDirectory ramDirectory = new RAMDirectory();
        IndexWriter indexWriter = new IndexWriter(ramDirectory, new IndexWriterConfig(analyzer));
        try {
            Iterable iterable = () -> docs.stream().map(ParsedDocument::docs).flatMap(Collection::stream).iterator();
            indexWriter.addDocuments(iterable);
            DirectoryReader directoryReader = DirectoryReader.open(indexWriter);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher(directoryReader);
            slowSearcher.setQueryCache(null);
            indexSearcher = slowSearcher;
        }
        catch (Throwable throwable) {
            try {
                try {
                    indexWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
            }
        }
        indexWriter.close();
        return indexSearcher;
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, QueryShardContext context, boolean mapUnmappedFieldsAsString) {
        Version indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            if (indexVersion.onOrAfter(Version.V_6_0_0_beta2)) {
                return docId -> {
                    if (binaryDocValues.advanceExact((int)docId)) {
                        BytesRef qbSource = binaryDocValues.binaryValue();
                        try (ByteArrayInputStream in = new ByteArrayInputStream(qbSource.bytes, qbSource.offset, qbSource.length);){
                            Query query;
                            try (NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput(new InputStreamStreamInput(in, qbSource.length), registry);){
                                ((StreamInput)input).setVersion(indexVersion);
                                int numValues = input.readVInt();
                                assert (numValues == 1);
                                int valueLength = input.readVInt();
                                assert (valueLength > 0);
                                QueryBuilder queryBuilder = ((StreamInput)input).readNamedWriteable(QueryBuilder.class);
                                assert (((InputStream)in).read() == -1);
                                query = PercolatorFieldMapper.toQuery(context, mapUnmappedFieldsAsString, queryBuilder);
                            }
                            return query;
                        }
                    }
                    return null;
                };
            }
            return docId -> {
                if (binaryDocValues.advanceExact((int)docId)) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    if (qbSource.length > 0) {
                        XContent xContent = PercolatorFieldMapper.QUERY_BUILDER_CONTENT_TYPE.xContent();
                        try (XContentParser sourceParser = xContent.createParser(context.getXContentRegistry(), LoggingDeprecationHandler.INSTANCE, qbSource.bytes, qbSource.offset, qbSource.length);){
                            Query query = PercolatorFieldMapper.parseQuery(context, mapUnmappedFieldsAsString, sourceParser);
                            return query;
                        }
                    }
                    return null;
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            @Override
            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createNormalizedWeight(query, false);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of(s.iterator(), context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            @Override
            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder(shardContext.getFullyQualifiedIndex().getName());
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build(shardContext.getIndexSettings(), fieldType, cache, circuitBreaker, shardContext.getMapperService());
            }
        };
    }
}

