/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.sampler;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.search.DiversifiedTopDocsCollector;
import conductor.org.apache.lucene.search.TopDocsCollector;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DiversifiedNumericSamplerAggregator
extends SamplerAggregator {
    private ValuesSource.Numeric valuesSource;
    private int maxDocsPerValue;

    DiversifiedNumericSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, ValuesSource.Numeric valuesSource, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.maxDocsPerValue = maxDocsPerValue;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector();
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector() {
            super(DiversifiedNumericSamplerAggregator.this.shardSize, DiversifiedNumericSamplerAggregator.this.context.bigArrays());
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            return new ValuesDiversifiedTopDocsCollector(size, DiversifiedNumericSamplerAggregator.this.maxDocsPerValue);
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedNumericDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedNumericSamplerAggregator.this.valuesSource.longValues(context);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return ValuesDiversifiedTopDocsCollector.this.values.docID();
                    }

                    @Override
                    public long longValue() throws IOException {
                        return ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                    }
                };
            }
        }
    }
}

