/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.mad;

import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregation;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import conductor.org.elasticsearch.search.aggregations.metrics.mad.MedianAbsoluteDeviation;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalMedianAbsoluteDeviation
extends InternalNumericMetricsAggregation.SingleValue
implements MedianAbsoluteDeviation {
    private final TDigestState valuesSketch;
    private final double medianAbsoluteDeviation;

    static double computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return Double.NaN;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = new TDigestState(valuesSketch.compression());
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return approximatedDeviationsSketch.quantile(0.5);
    }

    public InternalMedianAbsoluteDeviation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, TDigestState valuesSketch) {
        super(name, pipelineAggregators, metaData);
        this.format = Objects.requireNonNull(format);
        this.valuesSketch = Objects.requireNonNull(valuesSketch);
        this.medianAbsoluteDeviation = InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valuesSketch);
    }

    public InternalMedianAbsoluteDeviation(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.valuesSketch = TDigestState.read(in);
        this.medianAbsoluteDeviation = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        TDigestState.write(this.valuesSketch, out);
        out.writeDouble(this.medianAbsoluteDeviation);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TDigestState valueMerged = new TDigestState(this.valuesSketch.compression());
        for (InternalAggregation aggregation : aggregations) {
            InternalMedianAbsoluteDeviation madAggregation = (InternalMedianAbsoluteDeviation)aggregation;
            valueMerged.add(madAggregation.valuesSketch);
        }
        return new InternalMedianAbsoluteDeviation(this.name, this.pipelineAggregators(), this.metaData, this.format, valueMerged);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean anyResults = this.valuesSketch.size() > 0L;
        Double mad = anyResults ? Double.valueOf(this.getMedianAbsoluteDeviation()) : null;
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), mad);
        if (this.format != DocValueFormat.RAW && anyResults) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(mad).toString());
        }
        return builder;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.valuesSketch);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalMedianAbsoluteDeviation other = (InternalMedianAbsoluteDeviation)obj;
        return Objects.equals(this.valuesSketch, other.valuesSketch);
    }

    @Override
    public String getWriteableName() {
        return "median_absolute_deviation";
    }

    public TDigestState getValuesSketch() {
        return this.valuesSketch;
    }

    @Override
    public double value() {
        return this.getMedianAbsoluteDeviation();
    }

    @Override
    public double getMedianAbsoluteDeviation() {
        return this.medianAbsoluteDeviation;
    }
}

