/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.support;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.index.query.QueryShardContext;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class MultiValuesSource<VS extends ValuesSource> {
    protected Map<String, VS> values;

    public boolean needsScores() {
        return this.values.values().stream().anyMatch(ValuesSource::needsScores);
    }

    public String[] fieldNames() {
        return this.values.keySet().toArray(new String[0]);
    }

    public boolean areValuesSourcesEmpty() {
        return this.values.values().stream().allMatch(Objects::isNull);
    }

    public static class GeoPointValuesSource
    extends MultiValuesSource<ValuesSource.GeoPoint> {
        public GeoPointValuesSource(Map<String, ValuesSourceConfig<ValuesSource.GeoPoint>> valuesSourceConfigs, QueryShardContext context) throws IOException {
            this.values = new HashMap(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig<ValuesSource.GeoPoint>> entry : valuesSourceConfigs.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue().toValuesSource(context));
            }
        }
    }

    public static class BytesMultiValuesSource
    extends MultiValuesSource<ValuesSource.Bytes> {
        public BytesMultiValuesSource(Map<String, ValuesSourceConfig<ValuesSource.Bytes>> valuesSourceConfigs, QueryShardContext context) throws IOException {
            this.values = new HashMap(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig<ValuesSource.Bytes>> entry : valuesSourceConfigs.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue().toValuesSource(context));
            }
        }

        public Object getField(String fieldName, LeafReaderContext ctx) throws IOException {
            ValuesSource.Bytes value = (ValuesSource.Bytes)this.values.get(fieldName);
            if (value == null) {
                throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
            }
            return value.bytesValues(ctx);
        }
    }

    public static class NumericMultiValuesSource
    extends MultiValuesSource<ValuesSource.Numeric> {
        public NumericMultiValuesSource(Map<String, ValuesSourceConfig<ValuesSource.Numeric>> valuesSourceConfigs, QueryShardContext context) throws IOException {
            this.values = new HashMap(valuesSourceConfigs.size());
            for (Map.Entry<String, ValuesSourceConfig<ValuesSource.Numeric>> entry : valuesSourceConfigs.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue().toValuesSource(context));
            }
        }

        public SortedNumericDoubleValues getField(String fieldName, LeafReaderContext ctx) throws IOException {
            ValuesSource.Numeric value = (ValuesSource.Numeric)this.values.get(fieldName);
            if (value == null) {
                throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
            }
            return value.doubleValues(ctx);
        }
    }
}

