/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.profile;

import conductor.org.elasticsearch.search.internal.ContextIndexSearcher;
import conductor.org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import conductor.org.elasticsearch.search.profile.query.QueryProfiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Profilers {
    private final ContextIndexSearcher searcher;
    private final List<QueryProfiler> queryProfilers;
    private final AggregationProfiler aggProfiler;

    public Profilers(ContextIndexSearcher searcher) {
        this.searcher = searcher;
        this.queryProfilers = new ArrayList<QueryProfiler>();
        this.aggProfiler = new AggregationProfiler();
        this.addQueryProfiler();
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler profiler = new QueryProfiler();
        this.searcher.setProfiler(profiler);
        this.queryProfilers.add(profiler);
        return profiler;
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfilers.get(this.queryProfilers.size() - 1);
    }

    public List<QueryProfiler> getQueryProfilers() {
        return Collections.unmodifiableList(this.queryProfilers);
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }
}

