/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.completion;

import conductor.org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TopSuggestGroupDocsCollector
extends TopSuggestDocsCollector {
    private Map<Integer, List<CharSequence>> docContexts = new HashMap<Integer, List<CharSequence>>();

    TopSuggestGroupDocsCollector(int num, boolean skipDuplicates) {
        super(num, skipDuplicates);
    }

    List<CharSequence> getContexts(int doc) {
        return this.docContexts.getOrDefault(doc, Collections.emptyList());
    }

    @Override
    public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
        int globalDoc = docID + this.docBase;
        boolean isNewDoc = !this.docContexts.containsKey(globalDoc);
        List contexts = this.docContexts.computeIfAbsent(globalDoc, k -> new ArrayList());
        if (context != null) {
            contexts.add(context);
        }
        if (isNewDoc) {
            super.collect(docID, key, context, score);
        }
    }
}

