/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.action.Action;
import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.ActionListenerResponseHandler;
import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestBuilder;
import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.client.Client;
import conductor.org.elasticsearch.client.support.AbstractClient;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.RemoteClusterAwareRequest;
import conductor.org.elasticsearch.transport.RemoteClusterService;
import conductor.org.elasticsearch.transport.Transport;
import conductor.org.elasticsearch.transport.TransportRequest;
import conductor.org.elasticsearch.transport.TransportRequestOptions;
import conductor.org.elasticsearch.transport.TransportService;

final class RemoteClusterAwareClient
extends AbstractClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;

    RemoteClusterAwareClient(Settings settings, ThreadPool threadPool, TransportService service, String clusterAlias) {
        super(settings, threadPool);
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.wrap(res -> {
            Transport.Connection connection;
            if (request instanceof RemoteClusterAwareRequest) {
                DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
            } else {
                connection = this.remoteClusterService.getConnection(this.clusterAlias);
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(listener, action.getResponseReader()));
        }, listener::onFailure));
    }

    @Override
    public void close() {
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }
}

