/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.index.FieldInvertState;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.BasicStats;
import conductor.org.apache.lucene.search.similarities.MultiSimilarity;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.SmallFloat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class SimilarityBase
extends Similarity {
    private static final double LOG_2;
    protected boolean discountOverlaps = true;
    private static final float[] OLD_LENGTH_TABLE;
    private static final float[] LENGTH_TABLE;

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    @Override
    public final Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Similarity.SimWeight[] stats = new BasicStats[termStats.length];
        for (int i = 0; i < termStats.length; ++i) {
            stats[i] = this.newStats(collectionStats.field(), boost);
            this.fillBasicStats((BasicStats)stats[i], collectionStats, termStats[i]);
        }
        return stats.length == 1 ? stats[0] : new MultiSimilarity.MultiStats(stats);
    }

    protected BasicStats newStats(String field, float boost) {
        return new BasicStats(field, boost);
    }

    protected void fillBasicStats(BasicStats stats, CollectionStatistics collectionStats, TermStatistics termStats) {
        float avgFieldLength;
        long numberOfFieldTokens;
        assert (collectionStats.sumTotalTermFreq() == -1L || collectionStats.sumTotalTermFreq() >= termStats.totalTermFreq());
        long numberOfDocuments = collectionStats.docCount() == -1L ? collectionStats.maxDoc() : collectionStats.docCount();
        long docFreq = termStats.docFreq();
        long totalTermFreq = termStats.totalTermFreq();
        if (totalTermFreq == -1L) {
            totalTermFreq = docFreq;
        }
        if (collectionStats.sumTotalTermFreq() == -1L) {
            if (collectionStats.sumDocFreq() == -1L) {
                numberOfFieldTokens = docFreq;
                avgFieldLength = 1.0f;
            } else {
                numberOfFieldTokens = collectionStats.sumDocFreq();
                avgFieldLength = (float)((double)collectionStats.sumDocFreq() / (double)numberOfDocuments);
            }
        } else {
            numberOfFieldTokens = collectionStats.sumTotalTermFreq();
            avgFieldLength = (float)((double)collectionStats.sumTotalTermFreq() / (double)numberOfDocuments);
        }
        stats.setNumberOfDocuments(numberOfDocuments);
        stats.setNumberOfFieldTokens(numberOfFieldTokens);
        stats.setAvgFieldLength(avgFieldLength);
        stats.setDocFreq(docFreq);
        stats.setTotalTermFreq(totalTermFreq);
    }

    protected abstract float score(BasicStats var1, float var2, float var3);

    protected void explain(List<Explanation> subExpls, BasicStats stats, int doc, float freq, float docLen) {
    }

    protected Explanation explain(BasicStats stats, int doc, Explanation freq, float docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, doc, freq.getValue(), docLen);
        return Explanation.match(this.score(stats, freq.getValue(), docLen), "score(" + this.getClass().getSimpleName() + ", doc=" + doc + ", freq=" + freq.getValue() + "), computed from:", subs);
    }

    @Override
    public final Similarity.SimScorer simScorer(Similarity.SimWeight stats, LeafReaderContext context) throws IOException {
        int indexCreatedVersionMajor = context.reader().getMetaData().getCreatedVersionMajor();
        if (stats instanceof MultiSimilarity.MultiStats) {
            Similarity.SimWeight[] subStats = ((MultiSimilarity.MultiStats)stats).subStats;
            Similarity.SimScorer[] subScorers = new Similarity.SimScorer[subStats.length];
            for (int i = 0; i < subScorers.length; ++i) {
                BasicStats basicstats = (BasicStats)subStats[i];
                subScorers[i] = new BasicSimScorer(basicstats, indexCreatedVersionMajor, context.reader().getNormValues(basicstats.field));
            }
            return new MultiSimilarity.MultiSimScorer(subScorers);
        }
        BasicStats basicstats = (BasicStats)stats;
        return new BasicSimScorer(basicstats, indexCreatedVersionMajor, context.reader().getNormValues(basicstats.field));
    }

    public abstract String toString();

    @Override
    public final long computeNorm(FieldInvertState state) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        int indexCreatedVersionMajor = state.getIndexCreatedVersionMajor();
        if (indexCreatedVersionMajor >= 7) {
            return SmallFloat.intToByte4(numTerms);
        }
        return SmallFloat.floatToByte315((float)(1.0 / Math.sqrt(numTerms)));
    }

    public static double log2(double x) {
        return Math.log(x) / LOG_2;
    }

    static {
        int i;
        LOG_2 = Math.log(2.0);
        OLD_LENGTH_TABLE = new float[256];
        LENGTH_TABLE = new float[256];
        for (i = 1; i < 256; ++i) {
            float f = SmallFloat.byte315ToFloat((byte)i);
            SimilarityBase.OLD_LENGTH_TABLE[i] = 1.0f / (f * f);
        }
        SimilarityBase.OLD_LENGTH_TABLE[0] = 1.0f / OLD_LENGTH_TABLE[255];
        for (i = 0; i < 256; ++i) {
            SimilarityBase.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)i);
        }
    }

    final class BasicSimScorer
    extends Similarity.SimScorer {
        private final BasicStats stats;
        private final NumericDocValues norms;
        private final float[] normCache;

        BasicSimScorer(BasicStats stats, int indexCreatedVersionMajor, NumericDocValues norms) throws IOException {
            this.stats = stats;
            this.norms = norms;
            this.normCache = indexCreatedVersionMajor >= 7 ? LENGTH_TABLE : OLD_LENGTH_TABLE;
        }

        float getLengthValue(int doc) throws IOException {
            if (this.norms == null) {
                return 1.0f;
            }
            if (this.norms.advanceExact(doc)) {
                return this.normCache[Byte.toUnsignedInt((byte)this.norms.longValue())];
            }
            return 0.0f;
        }

        @Override
        public float score(int doc, float freq) throws IOException {
            return SimilarityBase.this.score(this.stats, freq, this.getLengthValue(doc));
        }

        @Override
        public Explanation explain(int doc, Explanation freq) throws IOException {
            return SimilarityBase.this.explain(this.stats, doc, freq, this.getLengthValue(doc));
        }

        @Override
        public float computeSlopFactor(int distance) {
            return 1.0f / (float)(distance + 1);
        }

        @Override
        public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
            return 1.0f;
        }
    }
}

