/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.spatial3d.geom;

import conductor.org.apache.lucene.spatial3d.geom.ArcDistance;
import conductor.org.apache.lucene.spatial3d.geom.GeoPoint;
import conductor.org.apache.lucene.spatial3d.geom.LinearDistance;
import conductor.org.apache.lucene.spatial3d.geom.LinearSquaredDistance;
import conductor.org.apache.lucene.spatial3d.geom.Membership;
import conductor.org.apache.lucene.spatial3d.geom.NormalDistance;
import conductor.org.apache.lucene.spatial3d.geom.NormalSquaredDistance;
import conductor.org.apache.lucene.spatial3d.geom.Plane;
import conductor.org.apache.lucene.spatial3d.geom.PlanetModel;

public interface DistanceStyle {
    public static final ArcDistance ARC = ArcDistance.INSTANCE;
    public static final LinearDistance LINEAR = LinearDistance.INSTANCE;
    public static final LinearSquaredDistance LINEAR_SQUARED = LinearSquaredDistance.INSTANCE;
    public static final NormalDistance NORMAL = NormalDistance.INSTANCE;
    public static final NormalSquaredDistance NORMAL_SQUARED = NormalSquaredDistance.INSTANCE;

    default public double computeDistance(GeoPoint point1, GeoPoint point2) {
        return this.computeDistance(point1, point2.x, point2.y, point2.z);
    }

    public double computeDistance(GeoPoint var1, double var2, double var4, double var6);

    default public double computeDistance(PlanetModel planetModel, Plane plane, GeoPoint point, Membership ... bounds) {
        return this.computeDistance(planetModel, plane, point.x, point.y, point.z, bounds);
    }

    public double computeDistance(PlanetModel var1, Plane var2, double var3, double var5, double var7, Membership ... var9);

    default public double toAggregationForm(double distance) {
        return distance;
    }

    default public double aggregateDistances(double distance1, double distance2) {
        return distance1 + distance2;
    }

    default public double fromAggregationForm(double aggregateDistance) {
        return aggregateDistance;
    }

    public GeoPoint[] findDistancePoints(PlanetModel var1, double var2, GeoPoint var4, Plane var5, Membership ... var6);

    public double findMinimumArcDistance(PlanetModel var1, double var2);

    public double findMaximumArcDistance(PlanetModel var1, double var2);
}

