/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.support.nodes;

import conductor.org.elasticsearch.action.ActionRequest;
import conductor.org.elasticsearch.action.ActionRequestValidationException;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.unit.TimeValue;
import java.io.IOException;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends ActionRequest {
    private String[] nodesIds;
    private DiscoveryNode[] concreteNodes;
    private TimeValue timeout;

    protected BaseNodesRequest() {
    }

    protected BaseNodesRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.nodesIds = null;
        this.concreteNodes = concreteNodes;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public final Request nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public final Request timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout");
        return (Request)this;
    }

    public DiscoveryNode[] concreteNodes() {
        return this.concreteNodes;
    }

    public void setConcreteNodes(DiscoveryNode[] concreteNodes) {
        this.concreteNodes = concreteNodes;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodesIds = in.readStringArray();
        this.concreteNodes = in.readOptionalArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.timeout = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.nodesIds);
        out.writeOptionalArray(this.concreteNodes);
        out.writeOptionalTimeValue(this.timeout);
    }
}

